/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.cache;

import cn.allbs.cache.listener.CacheMessageListener;
import cn.allbs.cache.properties.CacheConfigProperties;
import cn.allbs.cache.sequence.IdGeneratorUtil;
import cn.allbs.cache.support.RedisCaffeineCacheManager;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={CacheConfigProperties.class})
public class MultilevelCacheAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MultilevelCacheAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(value={RedisTemplate.class})
    public RedisCaffeineCacheManager cacheManager(CacheConfigProperties cacheConfigProperties, RedisTemplate<Object, Object> redisTemplate) {
        return new RedisCaffeineCacheManager(cacheConfigProperties, redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisSerializer.class})
    public RedisSerializer<Object> redisSerializer(ObjectProvider<ObjectMapper> objectProvider) {
        ObjectMapper objectMapper = ((ObjectMapper)objectProvider.getIfAvailable(ObjectMapper::new)).copy();
        objectMapper.findAndRegisterModules();
        GenericJackson2JsonRedisSerializer.registerNullValueSerializer((ObjectMapper)objectMapper, null);
        objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        return new GenericJackson2JsonRedisSerializer(objectMapper);
    }

    @Bean
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory, RedisSerializer<Object> redisSerializer) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer(redisSerializer);
        redisTemplate.setHashValueSerializer(redisSerializer);
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        return redisTemplate;
    }

    @Bean
    public RedisMessageListenerContainer redisMessageListenerContainer(CacheConfigProperties cacheConfigProperties, RedisTemplate<Object, Object> redisTemplate, RedisCaffeineCacheManager redisCaffeineCacheManager) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(redisTemplate.getConnectionFactory());
        CacheMessageListener cacheMessageListener = new CacheMessageListener(redisTemplate, redisCaffeineCacheManager);
        redisMessageListenerContainer.addMessageListener((MessageListener)cacheMessageListener, (Topic)new ChannelTopic(cacheConfigProperties.getRedis().getTopic()));
        return redisMessageListenerContainer;
    }

    @Bean
    @ConditionalOnBean(value={RedisTemplate.class})
    public IdGeneratorUtil idGeneratorUtil(RedisTemplate<Object, Object> redisTemplate) {
        return new IdGeneratorUtil(redisTemplate);
    }
}

