/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.cache.listener;

import cn.allbs.cache.listener.CacheMessage;
import cn.allbs.cache.support.RedisCaffeineCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;

public class CacheMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(CacheMessageListener.class);
    private final RedisTemplate<Object, Object> redisTemplate;
    private final RedisCaffeineCacheManager redisCaffeineCacheManager;

    public void onMessage(Message message, byte[] pattern) {
        CacheMessage cacheMessage = (CacheMessage)this.redisTemplate.getValueSerializer().deserialize(message.getBody());
        log.debug("receive a redis topic message, clear local cache, the cacheName is {}, the key is {}", (Object)cacheMessage.getCacheName(), cacheMessage.getKey());
        this.redisCaffeineCacheManager.clearLocal(cacheMessage.getCacheName(), cacheMessage.getKey());
    }

    public CacheMessageListener(RedisTemplate<Object, Object> redisTemplate, RedisCaffeineCacheManager redisCaffeineCacheManager) {
        this.redisTemplate = redisTemplate;
        this.redisCaffeineCacheManager = redisCaffeineCacheManager;
    }
}

