/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.cache.sequence;

import cn.allbs.cache.sequence.SequenceManage;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.springframework.data.redis.core.RedisTemplate;

public class IdGeneratorUtil {
    private final SequenceManage sequenceManage;

    public IdGeneratorUtil(RedisTemplate<Object, Object> redisTemplate) {
        this.sequenceManage = new SequenceManage(redisTemplate);
    }

    public String generateYMDId(String key, Integer length) {
        long num = this.sequenceManage.increment(key, this.getEndTime());
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + String.format("%0" + length + "d", num);
    }

    public String generatePreId(String key, String prefix, Integer length) {
        long num = this.sequenceManage.increment(key + ":" + prefix);
        return prefix + String.format("%0" + length + "d", num);
    }

    public String generatePreIdStep(String key, String prefix, Integer length, int step) {
        long num = this.sequenceManage.increment(key + ":" + prefix, step);
        return prefix + String.format("%0" + length + "d", num);
    }

    public String generatePreId(String key, String prefix, Integer length, int step) {
        long num = this.sequenceManage.increment(key + ":" + prefix, step);
        return prefix + String.format("%0" + length + "d", num);
    }

    public void initGenerate(String key, String prefix, int initialValue) {
        this.sequenceManage.initIncrement(key + ":" + prefix, initialValue);
    }

    public void initGenerate(String key, int initialValue) {
        this.sequenceManage.initIncrement(key, initialValue);
    }

    public Instant getEndTime() {
        LocalDateTime endTime = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
        return endTime.toInstant(ZoneOffset.ofHours(8));
    }
}

