/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.cache.sequence;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class SequenceManage {
    private final RedisTemplate<Object, Object> redisTemplate;

    public SequenceManage(RedisTemplate<Object, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public RedisConnectionFactory getConnectionFactory() {
        return this.redisTemplate.getConnectionFactory();
    }

    public long increment(String key) {
        RedisAtomicLong redisAtomicLong = new RedisAtomicLong(key, this.getConnectionFactory());
        return redisAtomicLong.incrementAndGet();
    }

    public long increment(String key, long time, TimeUnit timeUnit) {
        RedisAtomicLong redisAtomicLong = new RedisAtomicLong(key, this.getConnectionFactory());
        redisAtomicLong.expire(time, timeUnit);
        return redisAtomicLong.incrementAndGet();
    }

    public long increment(String key, Instant expireAt) {
        RedisAtomicLong redisAtomicLong = new RedisAtomicLong(key, this.getConnectionFactory());
        redisAtomicLong.expireAt(expireAt);
        return redisAtomicLong.incrementAndGet();
    }

    public long increment(String key, int increment, long time, TimeUnit timeUnit) {
        RedisAtomicLong redisAtomicLong = new RedisAtomicLong(key, this.getConnectionFactory());
        redisAtomicLong.expire(time, timeUnit);
        return redisAtomicLong.addAndGet((long)increment);
    }

    public long increment(String key, int increment) {
        RedisAtomicLong redisAtomicLong = new RedisAtomicLong(key, this.getConnectionFactory());
        return redisAtomicLong.addAndGet((long)increment);
    }

    public void initIncrement(String key, int initialValue) {
        RedisAtomicLong redisAtomicLong = new RedisAtomicLong(key, this.getConnectionFactory(), (long)initialValue);
    }
}

