/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.cache.support;

import cn.allbs.cache.properties.CacheConfigProperties;
import cn.allbs.cache.support.RedisCaffeineCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCaffeineCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(RedisCaffeineCacheManager.class);
    private ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();
    private CacheConfigProperties cacheConfigProperties;
    private RedisTemplate<Object, Object> redisTemplate;
    private boolean dynamic;
    private Set<String> cacheNames;

    public RedisCaffeineCacheManager(CacheConfigProperties cacheConfigProperties, RedisTemplate<Object, Object> redisTemplate) {
        this.cacheConfigProperties = cacheConfigProperties;
        this.redisTemplate = redisTemplate;
        this.dynamic = cacheConfigProperties.isDynamic();
        this.cacheNames = cacheConfigProperties.getCacheNames();
    }

    public Cache getCache(String name) {
        Object cache = (Cache)this.cacheMap.get(name);
        if (cache != null) {
            return cache;
        }
        if (!this.dynamic && !this.cacheNames.contains(name)) {
            return cache;
        }
        cache = new RedisCaffeineCache(name, this.redisTemplate, this.caffeineCache(), this.cacheConfigProperties);
        Cache oldCache = this.cacheMap.putIfAbsent(name, (Cache)cache);
        log.debug("create cache instance, the cache name is : {}", (Object)name);
        return oldCache == null ? cache : oldCache;
    }

    public com.github.benmanes.caffeine.cache.Cache<Object, Object> caffeineCache() {
        Caffeine cacheBuilder = Caffeine.newBuilder();
        if (this.cacheConfigProperties.getCaffeine().getExpireAfterAccess() > 0L) {
            cacheBuilder.expireAfterAccess(this.cacheConfigProperties.getCaffeine().getExpireAfterAccess(), TimeUnit.MILLISECONDS);
        }
        if (this.cacheConfigProperties.getCaffeine().getExpireAfterWrite() > 0L) {
            cacheBuilder.expireAfterWrite(this.cacheConfigProperties.getCaffeine().getExpireAfterWrite(), TimeUnit.MILLISECONDS);
        }
        if (this.cacheConfigProperties.getCaffeine().getInitialCapacity() > 0) {
            cacheBuilder.initialCapacity(this.cacheConfigProperties.getCaffeine().getInitialCapacity());
        }
        if (this.cacheConfigProperties.getCaffeine().getMaximumSize() > 0L) {
            cacheBuilder.maximumSize(this.cacheConfigProperties.getCaffeine().getMaximumSize());
        }
        if (this.cacheConfigProperties.getCaffeine().getRefreshAfterWrite() > 0L) {
            cacheBuilder.refreshAfterWrite(this.cacheConfigProperties.getCaffeine().getRefreshAfterWrite(), TimeUnit.MILLISECONDS);
        }
        return cacheBuilder.build();
    }

    public Collection<String> getCacheNames() {
        return this.cacheNames;
    }

    public void clearLocal(String cacheName, Object key) {
        Cache cache = (Cache)this.cacheMap.get(cacheName);
        if (cache == null) {
            return;
        }
        RedisCaffeineCache redisCaffeineCache = (RedisCaffeineCache)cache;
        redisCaffeineCache.clearLocal(key);
    }
}

