/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.hutool.core.convert.Convert;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DateStaticsSectionUtil {
    public static Map<String, BigDecimal> minuteSection(LocalDateTime startTime, LocalDateTime endTime, int interval, String pattern) {
        Duration duration = Duration.between(startTime, endTime);
        int num = Convert.toInt((Object)Math.ceil((float)duration.toMinutes() * 4.0f / 3.0f + 1.0f));
        LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>(num);
        while (startTime.isBefore(endTime)) {
            result.put(startTime.format(DateTimeFormatter.ofPattern(pattern)), new BigDecimal(0));
            startTime = startTime.plus(interval, ChronoUnit.MINUTES);
        }
        return result;
    }

    public static Map<String, BigDecimal> minuteSection(LocalDateTime startTime, LocalDateTime endTime, int interval) {
        return DateStaticsSectionUtil.minuteSection(startTime, endTime, interval, "MM-dd HH:mm");
    }

    public static Map<String, BigDecimal> minuteSection(LocalDateTime startTime, LocalDateTime endTime, String pattern) {
        return DateStaticsSectionUtil.minuteSection(startTime, endTime, 1, pattern);
    }

    public static Map<String, BigDecimal> minuteSection(LocalDateTime startTime, LocalDateTime endTime) {
        return DateStaticsSectionUtil.minuteSection(startTime, endTime, 1, "MM-dd HH:mm");
    }

    public static Map<String, BigDecimal> daySection(LocalDate startTime, LocalDate endTime, String pattern) {
        Period betweenDays = Period.between(startTime, endTime);
        int num = Convert.toInt((Object)Math.ceil((float)betweenDays.getDays() * 4.0f / 3.0f + 1.0f));
        LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>(num);
        while (startTime.isBefore(endTime)) {
            result.put(startTime.format(DateTimeFormatter.ofPattern(pattern)), new BigDecimal(0));
            startTime = startTime.plus(1L, ChronoUnit.DAYS);
        }
        return result;
    }

    public static Map<String, BigDecimal> daySection(LocalDate startTime, LocalDate endTime) {
        return DateStaticsSectionUtil.daySection(startTime, endTime, "MM-dd");
    }

    public static Map<String, BigDecimal> dayHour(LocalDate date, int interval, String pattern) {
        LocalDateTime startTime = LocalDateTime.of(date, LocalTime.of(0, 0, 0));
        LocalDateTime endTime = LocalDateTime.of(date, LocalTime.of(23, 59, 59));
        LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>(33);
        while (startTime.isBefore(endTime)) {
            result.put(startTime.format(DateTimeFormatter.ofPattern(pattern)), new BigDecimal(0));
            startTime = startTime.plus(interval, ChronoUnit.HOURS);
        }
        return result;
    }

    public static Map<String, BigDecimal> dayHour(LocalDate date, String pattern) {
        return DateStaticsSectionUtil.dayHour(date, 1, pattern);
    }

    public static Map<String, BigDecimal> dayHour(LocalDate date, int interval) {
        return DateStaticsSectionUtil.dayHour(date, interval, "HH");
    }

    public static Map<String, BigDecimal> dayHour(LocalDate date) {
        return DateStaticsSectionUtil.dayHour(date, 1, "HH");
    }

    public static Map<String, BigDecimal> monthDay(int year, int month, String pattern) {
        LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>(41);
        LocalDate startDate = LocalDate.of(year, month, 1);
        LocalDate endDate = startDate.plus(1L, ChronoUnit.MONTHS);
        while (startDate.isBefore(endDate)) {
            result.put(startDate.format(DateTimeFormatter.ofPattern(pattern)), new BigDecimal(0));
            startDate = startDate.plus(1L, ChronoUnit.DAYS);
        }
        return result;
    }

    public static Map<String, BigDecimal> monthDay(int year, int month) {
        return DateStaticsSectionUtil.monthDay(year, month, "MM-dd");
    }

    public static Map<String, BigDecimal> yearMonth(int year, String pattern) {
        LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>(17);
        for (int i = 1; i <= 12; ++i) {
            LocalDate date = LocalDate.of(year, i, 1);
            result.put(date.format(DateTimeFormatter.ofPattern(pattern)), new BigDecimal(0));
        }
        return result;
    }

    public static Map<String, BigDecimal> yearMonth(int year) {
        return DateStaticsSectionUtil.yearMonth(year, "MM");
    }

    private DateStaticsSectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

