/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.constant.ParamConstant;
import cn.allbs.enums.SolarRadiationEnum;
import cn.allbs.utils.CommonUtil;
import cn.allbs.utils.LngLatUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GaussUtil {
    private static double getSigmaY(double x, String q) {
        double a = 0.0;
        double r = 0.0;
        if (SolarRadiationEnum.A.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THOUSAND.intValue()) {
                a = 0.901074;
                r = 0.425809;
            } else {
                a = 0.850934;
                r = 0.602052;
            }
        } else if (SolarRadiationEnum.B.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THOUSAND.intValue()) {
                a = 0.91437;
                r = 0.281846;
            } else {
                a = 0.865014;
                r = 0.396353;
            }
        } else if (SolarRadiationEnum.BC.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THOUSAND.intValue()) {
                a = 0.919325;
                r = 0.2295;
            } else {
                a = 0.875086;
                r = 0.314238;
            }
        } else if (SolarRadiationEnum.C.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THOUSAND.intValue()) {
                a = 0.924279;
                r = 0.177154;
            } else {
                a = 0.885157;
                r = 0.232123;
            }
        } else if (SolarRadiationEnum.CD.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THOUSAND.intValue()) {
                a = 0.926849;
                r = 0.14394;
            } else {
                a = 0.88694;
                r = 0.189396;
            }
        } else if (SolarRadiationEnum.D.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THOUSAND.intValue()) {
                a = 0.929418;
                r = 0.110726;
            } else {
                a = 0.888723;
                r = 0.146669;
            }
        } else if (SolarRadiationEnum.DE.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THOUSAND.intValue()) {
                a = 0.925118;
                r = 0.0985631;
            } else {
                a = 0.892794;
                r = 0.124308;
            }
        } else if (SolarRadiationEnum.E.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THOUSAND.intValue()) {
                a = 0.920818;
                r = 0.0864001;
            } else {
                a = 0.896864;
                r = 0.101947;
            }
        } else if (x <= (double)ParamConstant.THOUSAND.intValue()) {
            a = 0.929418;
            r = 0.0553634;
        } else {
            a = 0.888723;
            r = 0.0733348;
        }
        return Math.pow(x, a) * r;
    }

    private static double getSigmaZ(double x, String q) {
        double a = 0.0;
        double r = 0.0;
        if (SolarRadiationEnum.A.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THREE_HUNDRED.intValue()) {
                a = 1.12154;
                r = 0.0799904;
            } else if (x > (double)ParamConstant.THREE_HUNDRED.intValue() || x <= (double)ParamConstant.FIVE_HUNDRED.intValue()) {
                a = 1.5136;
                r = 0.00854771;
            } else {
                a = 2.10881;
                r = 2.11545E-4;
            }
        } else if (SolarRadiationEnum.B.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.FIVE_HUNDRED.intValue()) {
                a = 0.964435;
                r = 0.12719;
            } else {
                a = 0.109356;
                r = 0.057025;
            }
        } else if (SolarRadiationEnum.BC.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.FIVE_HUNDRED.intValue()) {
                a = 0.941015;
                r = 0.114682;
            } else {
                a = 1.0077;
                r = 0.0757182;
            }
        } else if (SolarRadiationEnum.C.getLevel().equals(q)) {
            a = 0.917595;
            r = 0.106803;
        } else if (SolarRadiationEnum.CD.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.TWO_THOUSAND.intValue()) {
                a = 0.838628;
                r = 0.126152;
            } else if (x > (double)ParamConstant.TWO_THOUSAND.intValue() || x <= (double)ParamConstant.TEN_THOUSAND.intValue()) {
                a = 0.75641;
                r = 0.235667;
            } else {
                a = 0.815575;
                r = 0.136659;
            }
        } else if (SolarRadiationEnum.D.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THOUSAND.intValue()) {
                a = 0.826212;
                r = 0.104634;
            } else if (x > (double)ParamConstant.THOUSAND.intValue() || x <= (double)ParamConstant.TEN_THOUSAND.intValue()) {
                a = 0.632023;
                r = 0.400167;
            } else {
                a = 0.55536;
                r = 0.810763;
            }
        } else if (SolarRadiationEnum.DE.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.TWO_THOUSAND.intValue()) {
                a = 0.776864;
                r = 0.111771;
            } else if (x > (double)ParamConstant.TWO_THOUSAND.intValue() || x <= (double)ParamConstant.TEN_THOUSAND.intValue()) {
                a = 0.572347;
                r = 0.5289922;
            } else {
                a = 0.499149;
                r = 1.0381;
            }
        } else if (SolarRadiationEnum.E.getLevel().equals(q)) {
            if (x <= (double)ParamConstant.THOUSAND.intValue()) {
                a = 0.78837;
                r = 0.0927529;
            } else if (x > (double)ParamConstant.THOUSAND.intValue() || x <= (double)ParamConstant.TEN_THOUSAND.intValue()) {
                a = 0.565188;
                r = 0.433384;
            } else {
                a = 0.414743;
                r = 1.73241;
            }
        } else if (x <= (double)ParamConstant.THOUSAND.intValue()) {
            a = 0.7844;
            r = 0.0620765;
        } else if (x > (double)ParamConstant.THOUSAND.intValue() || x <= (double)ParamConstant.TEN_THOUSAND.intValue()) {
            a = 0.525969;
            r = 0.370015;
        } else {
            a = 0.322659;
            r = 2.40691;
        }
        return Math.pow(x, a) * r;
    }

    public static double groundPointSource(double q, double u, double x, double y, double z, Integer l) {
        double sigmaY = GaussUtil.getSigmaY(x, SolarRadiationEnum.solarRadiationLevel(l, u));
        double sigmaZ = GaussUtil.getSigmaZ(x, SolarRadiationEnum.solarRadiationLevel(l, u));
        return q / (Math.PI * u * sigmaY * sigmaZ) * Math.exp((Math.pow(y, 2.0) / Math.pow(sigmaY, 2.0) + Math.pow(z, 2.0) / Math.pow(sigmaZ, 2.0)) / 2.0 * -1.0) * Math.pow(10.0, 6.0);
    }

    public static double highPowerContinuousDiffusion(double q, double u, double h, double x, double y, double z, Integer l) {
        double sigmaY = GaussUtil.getSigmaY(x, SolarRadiationEnum.solarRadiationLevel(l, u));
        double sigmaZ = GaussUtil.getSigmaZ(x, SolarRadiationEnum.solarRadiationLevel(l, u));
        return q / (Math.PI * 2 * u * sigmaY * sigmaZ) * Math.exp(Math.pow(y, 2.0) * -1.0 / 2.0 / Math.pow(sigmaY, 2.0)) * (Math.exp(Math.pow(z - h, 2.0) * -1.0 / 2.0 / Math.pow(sigmaZ, 2.0)) + Math.exp(Math.pow(z + h, 2.0) * -1.0 / 2.0 / Math.pow(sigmaZ, 2.0))) * Math.pow(10.0, 6.0);
    }

    public static double powerContinuousDiffusionWithoutSigma(double q, double u, double h, double x, double y, double z) {
        return q / (0.2827433388230814 * u * Math.pow(x, 1.7)) * Math.exp(0.0 - Math.pow(y, 2.0) / 0.08 / Math.pow(x, 1.8)) * (Math.exp(0.0 - Math.pow(z - h, 2.0) / 0.08 / Math.pow(x, 1.6)) + Math.exp(0.0 - Math.pow(z + h, 2.0) / 0.08 / Math.pow(x, 1.6))) * Math.pow(10.0, 6.0);
    }

    public static double allGroundReflection(double q, double u, double h, double x, double y, Integer l) {
        double sigmaY = GaussUtil.getSigmaY(x, SolarRadiationEnum.solarRadiationLevel(l, u));
        double sigmaZ = GaussUtil.getSigmaZ(x, SolarRadiationEnum.solarRadiationLevel(l, u));
        return q / (Math.PI * u * sigmaY * sigmaZ) * Math.exp((Math.pow(y, 2.0) / Math.pow(sigmaY, 2.0) + Math.pow(h, 2.0) / Math.pow(sigmaZ, 2.0)) / 2.0 * -1.0) * Math.pow(10.0, 6.0);
    }

    public static double smokeConcentration(double q, double u, double t, double x, double y, double z) {
        double v = 2.0 * Math.pow(0.2 * Math.pow(x, 0.9), 2.0);
        return q / (0.44999999999999996 * Math.pow(x, 2.6)) * Math.exp(0.0 - Math.pow(x - u * t, 2.0) / v - Math.pow(y, 2.0) / v - Math.pow(z, 2.0) / (2.0 * Math.pow(0.2 * Math.pow(x, 0.8), 2.0))) * Math.pow(10.0, 6.0);
    }

    public static double liftingHeightOfSmokeCloud(double vs, double d, double ws) {
        return 2.4 * vs * d / ws;
    }

    public static List<Map<String, Double>> getGaussSmokePoints(double centerLng, double centerLat, double ws, double t, double h, double q, double angle) {
        return GaussUtil.getGaussSmokePoints(centerLng, centerLat, ws, t, h, q, 1, 1.0, angle);
    }

    public static List<Map<String, Double>> getGaussSmokePoints(double centerLng, double centerLat, double ws, double t, double h, double q, int speed, double step, double angle) {
        double totalX = ws * t * (double)speed;
        ArrayList xRange = CollUtil.toList((Object[])new Double[]{totalX, -totalX});
        ArrayList yRange = CollUtil.toList((Object[])new Double[]{totalX, -totalX});
        ArrayList zRange = CollUtil.toList((Object[])new Double[]{h});
        int section = Convert.toInt((Object)Math.ceil(totalX / step));
        for (int index = 0; index < section; ++index) {
            if (index != 0) {
                CommonUtil.notContainAdd(xRange, (double)index * step);
                CommonUtil.notContainAdd(xRange, (double)(-index) * step);
            }
            CommonUtil.notContainAdd(yRange, (double)index * step);
            CommonUtil.notContainAdd(yRange, (double)(-index) * step);
            CommonUtil.notContainAdd(zRange, h + (double)index * step);
            if (h - (double)index * step <= 0.0) {
                CommonUtil.notContainAdd(zRange, 0.0);
                continue;
            }
            CommonUtil.notContainAdd(zRange, h - (double)index * step);
        }
        ArrayList<Map<String, Double>> cMapList = new ArrayList<Map<String, Double>>();
        for (int i = 0; i < xRange.size(); ++i) {
            for (int j = 0; j < yRange.size(); ++j) {
                for (int k = 0; k < zRange.size(); ++k) {
                    HashMap<String, Double> cMap = new HashMap<String, Double>(5);
                    double x = (Double)xRange.get(i);
                    double y = (Double)yRange.get(j);
                    double z = (Double)zRange.get(k);
                    cMap.put("height", z);
                    double c = NumberUtil.round((double)GaussUtil.smokeConcentration(q, ws, t, x, y, z), (int)3).doubleValue();
                    if (c == 0.0) continue;
                    cMap.put("c", c);
                    GaussUtil.lngLatMapCount(x, y, centerLng, centerLat, angle, cMap);
                    cMapList.add(cMap);
                }
            }
        }
        return cMapList;
    }

    public static List<Map<String, Double>> getGaussPlumePointsInElevated(double centerLng, double centerLat, double ws, double h, double q, double d, double w, Integer l, int t, double angle) {
        return GaussUtil.getGaussPlumePointsInElevated(centerLng, centerLat, ws, h, q, d, w, l, t, 1, angle, 1.0);
    }

    public static List<Map<String, Double>> getGaussPlumePointsInElevated(double centerLng, double centerLat, double ws, double h, double q, double d, double w, Integer l, int t, int speed, double angle, double step) {
        double vs = q / (44.642857142857146 * w / 1000.0) / Math.PI * Math.pow(d / 2.0, 2.0);
        double totalH = GaussUtil.liftingHeightOfSmokeCloud(vs, d, ws) + h;
        double totalX = ws * (double)t * (double)speed;
        ArrayList xRange = CollUtil.toList((Object[])new Double[]{totalX});
        ArrayList yRange = CollUtil.toList((Object[])new Double[]{totalX, -totalX});
        ArrayList zRange = CollUtil.toList((Object[])new Double[]{totalH});
        int section = Convert.toInt((Object)Math.ceil(totalX / step));
        for (int index = 0; index < section; ++index) {
            if (index != 0) {
                CommonUtil.notContainAdd(xRange, (double)index * step);
            }
            CommonUtil.notContainAdd(yRange, (double)index * step);
            CommonUtil.notContainAdd(yRange, (double)(-index) * step);
            CommonUtil.notContainAdd(zRange, totalH + (double)index * step);
            if (totalH - (double)index * step <= 0.0) {
                CommonUtil.notContainAdd(zRange, 0.0);
                continue;
            }
            CommonUtil.notContainAdd(zRange, totalH - (double)index * step);
        }
        ArrayList<Map<String, Double>> cMapList = new ArrayList<Map<String, Double>>();
        for (int i = 0; i < xRange.size(); ++i) {
            for (int j = 0; j < yRange.size(); ++j) {
                for (int k = 0; k < zRange.size(); ++k) {
                    HashMap<String, Double> cMap = new HashMap<String, Double>(5);
                    double x = (Double)xRange.get(i);
                    double y = (Double)yRange.get(j);
                    double z = (Double)zRange.get(k);
                    cMap.put("height", z);
                    double c = z == 0.0 ? NumberUtil.round((double)GaussUtil.allGroundReflection(q, ws, totalH, x, Math.abs(y), l), (int)3).doubleValue() : NumberUtil.round((double)GaussUtil.highPowerContinuousDiffusion(q, ws, totalH, x, Math.abs(y), z, l), (int)3).doubleValue();
                    if (c == 0.0) continue;
                    cMap.put("c", c);
                    GaussUtil.lngLatMapCount(x, y, centerLng, centerLat, angle, cMap);
                    cMapList.add(cMap);
                }
            }
        }
        return cMapList;
    }

    public static List<Map<String, Double>> getGaussPlumePointsInFloor(double centerLng, double centerLat, double ws, double q, Integer l, int t, double angle) {
        return GaussUtil.getGaussPlumePointsInFloor(centerLng, centerLat, ws, q, l, t, 1, angle, 1.0);
    }

    public static List<Map<String, Double>> getGaussPlumePointsInFloor(double centerLng, double centerLat, double ws, double q, Integer l, int t, int speed, double angle, double step) {
        double totalX = ws * (double)t * (double)speed;
        ArrayList xRange = CollUtil.toList((Object[])new Double[]{totalX});
        ArrayList yRange = CollUtil.toList((Object[])new Double[]{0.0, totalX, -totalX});
        ArrayList zRange = CollUtil.toList((Object[])new Double[]{0.0, totalX});
        int section = Convert.toInt((Object)Math.ceil(totalX / step));
        for (int index = 1; index < section; ++index) {
            if (index != 0) {
                CommonUtil.notContainAdd(xRange, (double)index * step);
            }
            CommonUtil.notContainAdd(yRange, (double)index * step);
            CommonUtil.notContainAdd(yRange, (double)(-index) * step);
            CommonUtil.notContainAdd(zRange, (double)index * step);
        }
        ArrayList<Map<String, Double>> cMapList = new ArrayList<Map<String, Double>>();
        for (int i = 0; i < xRange.size(); ++i) {
            block2: for (int j = 0; j < yRange.size(); ++j) {
                for (int k = 0; k < zRange.size(); ++k) {
                    HashMap<String, Double> cMap = new HashMap<String, Double>(5);
                    double x = (Double)xRange.get(i);
                    double y = (Double)yRange.get(j);
                    double z = (Double)zRange.get(k);
                    cMap.put("height", z);
                    double c = NumberUtil.round((double)GaussUtil.groundPointSource(q, ws, x, Math.abs(y), z, l), (int)3).doubleValue();
                    if (c == 0.0) continue block2;
                    cMap.put("c", c);
                    GaussUtil.lngLatMapCount(x, y, centerLng, centerLat, angle, cMap);
                    cMapList.add(cMap);
                }
            }
        }
        return cMapList;
    }

    public static List<Map<String, Double>> gaussianPlume(double centerLng, double centerLat, double ws, double q, int t, double h, double angle) {
        return GaussUtil.gaussianPlume(centerLng, centerLat, ws, q, t, 1, h, angle, 1.0);
    }

    public static List<Map<String, Double>> gaussianPlume(double centerLng, double centerLat, double ws, double q, int t, int speed, double h, double angle, double step) {
        double totalX = ws * (double)t * (double)speed;
        ArrayList xRange = CollUtil.toList((Object[])new Double[]{totalX});
        ArrayList yRange = CollUtil.toList((Object[])new Double[]{totalX, -totalX});
        ArrayList zRange = CollUtil.toList((Object[])new Double[]{h});
        int section = Convert.toInt((Object)Math.ceil(totalX / step));
        for (int index = 0; index < section; ++index) {
            if (index != 0) {
                CommonUtil.notContainAdd(xRange, (double)index * step);
            }
            CommonUtil.notContainAdd(yRange, (double)index * step);
            CommonUtil.notContainAdd(yRange, (double)(-index) * step);
            CommonUtil.notContainAdd(zRange, h + (double)index * step);
            if (h - (double)index * step <= 0.0) {
                CommonUtil.notContainAdd(zRange, 0.0);
                continue;
            }
            CommonUtil.notContainAdd(zRange, h - (double)index * step);
        }
        ArrayList<Map<String, Double>> cMapList = new ArrayList<Map<String, Double>>();
        for (int i = 0; i < xRange.size(); ++i) {
            for (int j = 0; j < yRange.size(); ++j) {
                for (int k = 0; k < zRange.size(); ++k) {
                    HashMap<String, Double> cMap = new HashMap<String, Double>(5);
                    double x = (Double)xRange.get(i);
                    double y = (Double)yRange.get(j);
                    double z = (Double)zRange.get(k);
                    cMap.put("height", z);
                    double c = NumberUtil.round((double)GaussUtil.powerContinuousDiffusionWithoutSigma(q, ws, h, x, y, z), (int)3).doubleValue();
                    if (c == 0.0) continue;
                    cMap.put("c", c);
                    GaussUtil.lngLatMapCount(x, y, centerLng, centerLat, angle, cMap);
                    cMapList.add(cMap);
                }
            }
        }
        return cMapList;
    }

    private static void lngLatMapCount(double x, double y, double centerLng, double centerLat, double angle, Map<String, Double> cMap) {
        Map<Object, Object> lngLatMap = new HashMap<String, Double>(4);
        if (x == 0.0 && y == 0.0) {
            lngLatMap.put("lng", centerLng);
            lngLatMap.put("lat", centerLat);
        } else if (x == 0.0) {
            lngLatMap = LngLatUtil.calLocationByDistanceAndLocationAndDirection(90.0 - angle, centerLng, centerLat, y);
        } else if (y == 0.0) {
            lngLatMap = LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle, centerLng, centerLat, x);
        } else {
            double dis = Math.sqrt(x * x + y * y);
            double ag = Math.toDegrees(Math.atan2(Math.abs(y), x));
            lngLatMap = y > 0.0 ? LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle - ag, centerLng, centerLat, dis) : LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle + ag, centerLng, centerLat, dis);
        }
        cMap.put("lng", (Double)lngLatMap.get("lng"));
        cMap.put("lat", (Double)lngLatMap.get("lat"));
    }

    private GaussUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

