/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.enums.WaterQualityItemEnum;
import cn.hutool.core.map.MapUtil;
import java.util.ArrayList;
import java.util.Map;

public final class WaterGradeUtil {
    public static Integer countWaterGrade(Map<String, Double> pollutantMap) {
        return WaterGradeUtil.countWaterGrade(pollutantMap, false);
    }

    public static Integer countWaterGrade(Map<String, Double> pollutantMap, boolean isLakeOrReservoir) {
        if (MapUtil.isNotEmpty(pollutantMap)) {
            ArrayList list = new ArrayList();
            pollutantMap.forEach((k, v) -> {
                if (v == null) {
                    return;
                }
                Integer grade = WaterQualityItemEnum.waterLevelCount(k, isLakeOrReservoir, v);
                if (grade == null) {
                    return;
                }
                list.add(grade);
            });
            return list.stream().max(Integer::compareTo).orElse(null);
        }
        return null;
    }

    private WaterGradeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

