/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

public final class GPSConverterUtils {
    private static final double A = 6378137.0;
    static double x_pi = 52.35987755982988;
    static double ee = 0.006693421622965943;

    public static double[] bd09toWgs84(double lng, double lat) {
        double[] gcj = GPSConverterUtils.bd09toGcj02(lng, lat);
        return GPSConverterUtils.gcj02toWgs84(gcj[0], gcj[1]);
    }

    public static double[] wgs84toBd09(double lng, double lat) {
        double[] gcj = GPSConverterUtils.wgs84toGcj02(lng, lat);
        return GPSConverterUtils.gcj02toBd09(gcj[0], gcj[1]);
    }

    public static double[] gcj02toBd09(double lng, double lat) {
        double z = Math.sqrt(lng * lng + lat * lat) + 2.0E-5 * Math.sin(lat * x_pi);
        double theta = Math.atan2(lat, lng) + 3.0E-6 * Math.cos(lng * x_pi);
        double bdLng = z * Math.cos(theta) + 0.0065;
        double bdLat = z * Math.sin(theta) + 0.006;
        return new double[]{bdLng, bdLat};
    }

    public static double[] bd09toGcj02(double bdLon, double bdLat) {
        double x = bdLon - 0.0065;
        double y = bdLat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * x_pi);
        double ggLng = z * Math.cos(theta);
        double ggLat = z * Math.sin(theta);
        return new double[]{ggLng, ggLat};
    }

    public static double[] wgs84toGcj02(double lng, double lat) {
        if (GPSConverterUtils.outOfChina(lng, lat)) {
            return new double[]{lng, lat};
        }
        double dLat = GPSConverterUtils.transFormLat(lng - 105.0, lat - 35.0);
        double dLng = GPSConverterUtils.transFormLng(lng - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (6378137.0 * (1.0 - ee) / (magic * sqrtMagic) * Math.PI);
        dLng = dLng * 180.0 / (6378137.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
        double mgLat = lat + dLat;
        double mgLng = lng + dLng;
        return new double[]{mgLng, mgLat};
    }

    public static double[] gcj02toWgs84(double lng, double lat) {
        if (GPSConverterUtils.outOfChina(lng, lat)) {
            return new double[]{lng, lat};
        }
        double dLat = GPSConverterUtils.transFormLat(lng - 105.0, lat - 35.0);
        double dLng = GPSConverterUtils.transFormLng(lng - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (6378137.0 * (1.0 - ee) / (magic * sqrtMagic) * Math.PI);
        dLng = dLng * 180.0 / (6378137.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
        double mgLat = lat + dLat;
        double mgLng = lng + dLng;
        return new double[]{lng * 2.0 - mgLng, lat * 2.0 - mgLat};
    }

    public static double transFormLat(double lng, double lat) {
        double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat + 0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lat / 12.0 * Math.PI) + 320.0 * Math.sin(lat * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    public static double transFormLng(double lng, double lat) {
        double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng + 0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lng * Math.PI) + 40.0 * Math.sin(lng / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lng / 12.0 * Math.PI) + 300.0 * Math.sin(lng / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    public static boolean outOfChina(double lng, double lat) {
        if (lng < 72.004 || lng > 137.8347) {
            return true;
        }
        return lat < 0.8293 || lat > 55.8271;
    }

    private GPSConverterUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

