/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.constant.ParamConstant;
import cn.allbs.enums.CoordinateSystemEnum;
import cn.allbs.model.Point3D;
import cn.allbs.utils.GPSConverterUtils;
import cn.allbs.utils.IntervalUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.json.JSONArray;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LngLatUtil {
    private static final double WGS84_EARTH_RADIUS = 6378137.0;
    private static final double WGS84_OBLIQUENESS = 298.257223563;

    public static double getDistanceOfMeter(double startLng, double startLat, double endLng, double endLat) {
        double f = 0.0033528106647474805;
        double b = (1.0 - f) * 6378137.0;
        double a2b2b2 = (Math.pow(6378137.0, 2.0) - Math.pow(b, 2.0)) / Math.pow(b, 2.0);
        double omega = Math.toRadians(endLng) - Math.toRadians(startLng);
        double atPhi1 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(startLat)));
        double sinU1 = Math.sin(atPhi1);
        double cosU1 = Math.cos(atPhi1);
        double atanPhi2 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(endLat)));
        double sinU2 = Math.sin(atanPhi2);
        double cosU2 = Math.cos(atanPhi2);
        double sinU1sinU2 = sinU1 * sinU2;
        double cosU1sinU2 = cosU1 * sinU2;
        double sinU1cosU2 = sinU1 * cosU2;
        double cosU1cosU2 = cosU1 * cosU2;
        double lambda = omega;
        double a = 0.0;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        for (int i = 0; i < ParamConstant.OBLIQUENESS_NUM; ++i) {
            double lambda0 = lambda;
            double sinLambda = Math.sin(lambda);
            double cosLambda = Math.cos(lambda);
            double sin2Sigma = cosU2 * sinLambda * cosU2 * sinLambda + (cosU1sinU2 - sinU1cosU2 * cosLambda) * (cosU1sinU2 - sinU1cosU2 * cosLambda);
            double sinSigma = Math.sqrt(sin2Sigma);
            double cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = BigDecimal.valueOf(sin2Sigma).equals(BigDecimal.valueOf(0L)) ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            double alpha = Math.asin(sinAlpha);
            double cosAlpha = Math.cos(alpha);
            double cos2alpha = cosAlpha * cosAlpha;
            double cos2SigmaM = BigDecimal.valueOf(cos2alpha).equals(BigDecimal.valueOf(0L)) ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cos2alpha;
            double u2 = cos2alpha * a2b2b2;
            double cos2SigmaM2 = cos2SigmaM * cos2SigmaM;
            a = 1.0 + u2 / 16384.0 * (4096.0 + u2 * (-768.0 + u2 * (320.0 - 175.0 * u2)));
            double B = u2 / 1024.0 * (256.0 + u2 * (-128.0 + u2 * (74.0 - 47.0 * u2)));
            deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM2) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sin2Sigma) * (-3.0 + 4.0 * cos2SigmaM2)));
            double C = f / 16.0 * cos2alpha * (4.0 + f * (4.0 - 3.0 * cos2alpha));
            lambda = omega + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM2)));
            double change = Math.abs((lambda - lambda0) / lambda);
            if (i > 1 && change < 1.0E-13) break;
        }
        return b * a * (sigma - deltaSigma);
    }

    public static double getDistance(double startLng, double startLat, double endLng, double endLat) {
        double radLat1 = Math.toRadians(startLat);
        double radLat2 = Math.toRadians(endLat);
        double a = radLat1 - radLat2;
        double b = Math.toRadians(startLng) - Math.toRadians(endLng);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6378137.0;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return s;
    }

    public static double getDistance(double startLng, double startLat, double endLng, double endLat, CoordinateSystemEnum coordinateSystemEnum) {
        if (coordinateSystemEnum.equals((Object)CoordinateSystemEnum.GCJ02)) {
            double[] start = GPSConverterUtils.gcj02toWgs84(startLng, startLat);
            double[] end = GPSConverterUtils.gcj02toWgs84(endLng, endLat);
            return LngLatUtil.getDistance(start[0], start[1], end[0], end[1]);
        }
        if (coordinateSystemEnum.equals((Object)CoordinateSystemEnum.BD09)) {
            double[] start = GPSConverterUtils.bd09toWgs84(startLng, startLat);
            double[] end = GPSConverterUtils.bd09toWgs84(endLng, endLat);
            return LngLatUtil.getDistance(start[0], start[1], end[0], end[1]);
        }
        return LngLatUtil.getDistance(startLng, startLat, endLng, endLat);
    }

    public static Map<String, Double> calLocationByDistanceAndLocationAndDirection(double angle, double startLng, double startLat, double distance) {
        HashMap<String, Double> result = new HashMap<String, Double>(5);
        double sigma = distance / 6378137.0;
        angle = Math.toRadians(angle);
        startLng = Math.toRadians(startLng);
        startLat = Math.toRadians(startLat);
        double lat = Math.asin(Math.sin(startLat) * Math.cos(sigma) + Math.cos(startLat) * Math.sin(sigma) * Math.cos(angle));
        double lng = startLng + Math.atan2(Math.sin(angle) * Math.sin(sigma) * Math.cos(startLat), Math.cos(sigma) - Math.sin(startLat) * Math.sin(lat));
        lng = Math.toDegrees(lng);
        lat = Math.toDegrees(lat);
        result.put("lng", NumberUtil.round((double)lng, (int)6).doubleValue());
        result.put("lat", NumberUtil.round((double)lat, (int)6).doubleValue());
        return result;
    }

    public static Map<String, Double> calLocationByDistanceAndLocationAndDirection(double angle, double startLng, double startLat, double distance, CoordinateSystemEnum coordinateSystemEnum) {
        if (coordinateSystemEnum.equals((Object)CoordinateSystemEnum.GCJ02)) {
            double[] trans = GPSConverterUtils.gcj02toWgs84(startLng, startLat);
            return LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle, trans[0], trans[1], distance);
        }
        if (coordinateSystemEnum.equals((Object)CoordinateSystemEnum.BD09)) {
            double[] trans = GPSConverterUtils.bd09toWgs84(startLng, startLat);
            return LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle, trans[0], trans[1], distance);
        }
        return LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle, startLng, startLat, distance);
    }

    public static boolean isInCircle(double lng1, double lat1, double lng2, double lat2, double radius) {
        return LngLatUtil.getDistance(lng1, lat1, lng2, lat2) <= radius;
    }

    public static boolean isInCircle(double lng1, double lat1, double lng2, double lat2, double radius, CoordinateSystemEnum coordinateSystemEnum) {
        return LngLatUtil.getDistance(lng1, lat1, lng2, lat2, coordinateSystemEnum) <= radius;
    }

    public static boolean isInPolygon(double pointLon, double pointLat, JSONArray points) {
        Point2D.Double point = new Point2D.Double(pointLon, pointLat);
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
        int len = points.size();
        for (int i = 0; i < len; ++i) {
            double polygonPointX = points.getJSONObject((Object)i).getDouble((Object)"x");
            double polygonPointY = points.getJSONObject((Object)i).getDouble((Object)"y");
            Point2D.Double polygonPoint = new Point2D.Double(polygonPointX, polygonPointY);
            pointList.add(polygonPoint);
        }
        return LngLatUtil.check(point, pointList);
    }

    public static boolean isInPolygon(double pointLon, double pointLat, JSONArray points, CoordinateSystemEnum coordinateSystemEnum) {
        double[] trans;
        if (coordinateSystemEnum.equals((Object)CoordinateSystemEnum.GCJ02)) {
            trans = GPSConverterUtils.gcj02toWgs84(pointLon, pointLat);
            pointLon = trans[0];
            pointLat = trans[1];
        }
        if (coordinateSystemEnum.equals((Object)CoordinateSystemEnum.BD09)) {
            trans = GPSConverterUtils.bd09toWgs84(pointLon, pointLat);
            pointLon = trans[0];
            pointLat = trans[1];
        }
        Point2D.Double point = new Point2D.Double(pointLon, pointLat);
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
        int len = points.size();
        for (int i = 0; i < len; ++i) {
            double[] trans2;
            double polygonPointX = points.getJSONObject((Object)i).getDouble((Object)"x");
            double polygonPointY = points.getJSONObject((Object)i).getDouble((Object)"y");
            if (coordinateSystemEnum.equals((Object)CoordinateSystemEnum.GCJ02)) {
                trans2 = GPSConverterUtils.gcj02toWgs84(polygonPointX, polygonPointY);
                polygonPointX = trans2[0];
                polygonPointY = trans2[1];
            }
            if (coordinateSystemEnum.equals((Object)CoordinateSystemEnum.BD09)) {
                trans2 = GPSConverterUtils.bd09toWgs84(polygonPointX, polygonPointY);
                polygonPointX = trans2[0];
                polygonPointY = trans2[1];
            }
            Point2D.Double polygonPoint = new Point2D.Double(polygonPointX, polygonPointY);
            pointList.add(polygonPoint);
        }
        return LngLatUtil.check(point, pointList);
    }

    private static boolean check(Point2D.Double point, List<Point2D.Double> polygon) {
        GeneralPath penalPath = new GeneralPath();
        Point2D.Double first = polygon.get(0);
        penalPath.moveTo(first.x, first.y);
        polygon.remove(0);
        for (Point2D.Double d : polygon) {
            penalPath.lineTo(d.x, d.y);
        }
        penalPath.lineTo(first.x, first.y);
        penalPath.closePath();
        return penalPath.contains(point);
    }

    public static boolean isInSector(double startLng, double startLat, double angel, double diffuse, double checkLng, double checkLat) {
        double minAngel = angel - diffuse;
        double maxAngel = angel + diffuse;
        double st = Math.atan2(checkLat - startLat, checkLng - startLng);
        return IntervalUtil.checkInAllCloseInterval(minAngel, maxAngel, (st - Math.PI * 2) * 180.0 / Math.PI) || IntervalUtil.checkInAllCloseInterval(minAngel, maxAngel, st * 180.0 / Math.PI) || IntervalUtil.checkInAllCloseInterval(minAngel, maxAngel, (st + Math.PI * 2) * 180.0 / Math.PI);
    }

    public static boolean isInSector(double startLng, double startLat, double angel, double diffuse, double checkLng, double checkLat, Double distance) {
        if (!LngLatUtil.isInCircle(startLng, startLat, checkLng, checkLat, distance)) {
            return false;
        }
        return LngLatUtil.isInSector(startLng, startLat, angel, diffuse, checkLng, checkLat);
    }

    public static Point3D calLocationByDistanceAndLocationAndDirection(double angle, Point3D point3D, double distance) {
        double sigma = distance / 6378137.0;
        angle = Math.toRadians(angle);
        point3D.setX(Math.toRadians(point3D.getX()));
        point3D.setY(Math.toRadians(point3D.getY()));
        double lat = Math.asin(Math.sin(point3D.getY()) * Math.cos(sigma) + Math.cos(point3D.getY()) * Math.sin(sigma) * Math.cos(angle));
        double lng = point3D.getX() + Math.atan2(Math.sin(angle) * Math.sin(sigma) * Math.cos(point3D.getY()), Math.cos(sigma) - Math.sin(point3D.getY()) * Math.sin(lat));
        lng = Math.toDegrees(lng);
        lat = Math.toDegrees(lat);
        return new Point3D(NumberUtil.round((double)lng, (int)6).doubleValue(), NumberUtil.round((double)lat, (int)6).doubleValue(), point3D.getZ());
    }

    private LngLatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

