/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.model.EarthPoint3D;
import cn.allbs.model.Point3D;
import cn.allbs.utils.LngLatUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class SpaceGeometryUtil {
    public static Set<Point3D> cubePeak(Point3D point3D, double distance) {
        HashSet<Point3D> points = new HashSet<Point3D>();
        points.add(new Point3D(point3D.getX() - distance, point3D.getY() - distance, point3D.getZ() + distance));
        points.add(new Point3D(point3D.getX() - distance, point3D.getY() - distance, point3D.getZ() - distance));
        points.add(new Point3D(point3D.getX() + distance, point3D.getY() - distance, point3D.getZ() - distance));
        points.add(new Point3D(point3D.getX() + distance, point3D.getY() - distance, point3D.getZ() + distance));
        points.add(new Point3D(point3D.getX() + distance, point3D.getY() + distance, point3D.getZ() + distance));
        points.add(new Point3D(point3D.getX() + distance, point3D.getY() + distance, point3D.getZ() - distance));
        points.add(new Point3D(point3D.getX() - distance, point3D.getY() + distance, point3D.getZ() - distance));
        points.add(new Point3D(point3D.getX() - distance, point3D.getY() + distance, point3D.getZ() + distance));
        return points;
    }

    public static Set<Set<Point3D>> cubeFace(Point3D point3D, double distance) {
        HashSet<Set<Point3D>> faces = new HashSet<Set<Point3D>>();
        Set<Point3D> points = SpaceGeometryUtil.cubePeak(point3D, distance);
        Point3D[] pointsArray = (Point3D[])ArrayUtil.toArray(points, Point3D.class);
        faces.add(CollUtil.newHashSet((Object[])new Point3D[]{pointsArray[0], pointsArray[0], pointsArray[0], pointsArray[0]}));
        faces.add(CollUtil.newHashSet((Object[])new Point3D[]{pointsArray[3], pointsArray[2], pointsArray[5], pointsArray[4]}));
        faces.add(CollUtil.newHashSet((Object[])new Point3D[]{pointsArray[4], pointsArray[5], pointsArray[6], pointsArray[7]}));
        faces.add(CollUtil.newHashSet((Object[])new Point3D[]{pointsArray[7], pointsArray[6], pointsArray[1], pointsArray[0]}));
        faces.add(CollUtil.newHashSet((Object[])new Point3D[]{pointsArray[7], pointsArray[0], pointsArray[3], pointsArray[4]}));
        faces.add(CollUtil.newHashSet((Object[])new Point3D[]{pointsArray[1], pointsArray[6], pointsArray[5], pointsArray[2]}));
        return faces;
    }

    public static Set<Point3D> batchPeak(Point3D point3D, double distance, double extendDis) {
        Set<Point3D> centerPoints = SpaceGeometryUtil.cubePeak(point3D, distance);
        HashSet<Point3D> batchPoints = new HashSet<Point3D>(centerPoints);
        centerPoints.forEach(point -> batchPoints.addAll(SpaceGeometryUtil.cubePeak(point, extendDis)));
        return batchPoints;
    }

    public static Set<Point3D> earthCubePeak(Point3D point3D, double distance) {
        HashSet<Point3D> points = new HashSet<Point3D>();
        points.add(LngLatUtil.calLocationByDistanceAndLocationAndDirection(225.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() + distance), Math.sqrt(2.0) * distance));
        points.add(LngLatUtil.calLocationByDistanceAndLocationAndDirection(225.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() - distance), Math.sqrt(2.0) * distance));
        points.add(LngLatUtil.calLocationByDistanceAndLocationAndDirection(135.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() - distance), Math.sqrt(2.0) * distance));
        points.add(LngLatUtil.calLocationByDistanceAndLocationAndDirection(135.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() + distance), Math.sqrt(2.0) * distance));
        points.add(LngLatUtil.calLocationByDistanceAndLocationAndDirection(45.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() + distance), Math.sqrt(2.0) * distance));
        points.add(LngLatUtil.calLocationByDistanceAndLocationAndDirection(45.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() - distance), Math.sqrt(2.0) * distance));
        points.add(LngLatUtil.calLocationByDistanceAndLocationAndDirection(315.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() - distance), Math.sqrt(2.0) * distance));
        points.add(LngLatUtil.calLocationByDistanceAndLocationAndDirection(315.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() + distance), Math.sqrt(2.0) * distance));
        return points;
    }

    public static Set<Point3D> earthBatchPeak(Point3D point3D, double distance, double extendDis) {
        Set<Point3D> centerPoints = SpaceGeometryUtil.earthCubePeak(point3D, distance);
        HashSet<Point3D> batchPoints = new HashSet<Point3D>(centerPoints);
        centerPoints.forEach(point -> batchPoints.addAll(SpaceGeometryUtil.earthCubePeak(point, extendDis)));
        return batchPoints;
    }

    public static Set<EarthPoint3D> earthCubePeakDetail(Point3D point3D, double distance, double angle) {
        HashSet<EarthPoint3D> points = new HashSet<EarthPoint3D>();
        points.add(new EarthPoint3D(LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle + 225.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() + distance), Math.sqrt(2.0) * distance), -distance, -distance, distance));
        points.add(new EarthPoint3D(LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle + 225.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() - distance), Math.sqrt(2.0) * distance), -distance, -distance, -distance));
        points.add(new EarthPoint3D(LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle + 135.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() - distance), Math.sqrt(2.0) * distance), distance, -distance, -distance));
        points.add(new EarthPoint3D(LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle + 135.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() + distance), Math.sqrt(2.0) * distance), distance, -distance, distance));
        points.add(new EarthPoint3D(LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle + 45.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() + distance), Math.sqrt(2.0) * distance), distance, distance, distance));
        points.add(new EarthPoint3D(LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle + 45.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() - distance), Math.sqrt(2.0) * distance), distance, distance, -distance));
        points.add(new EarthPoint3D(LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle + 315.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() - distance), Math.sqrt(2.0) * distance), -distance, distance, -distance));
        points.add(new EarthPoint3D(LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle + 315.0, new Point3D(point3D.getX(), point3D.getY(), point3D.getZ() + distance), Math.sqrt(2.0) * distance), -distance, distance, distance));
        return points;
    }

    public static Set<EarthPoint3D> earthBatchPeakDetail(Point3D point3D, double distance, double extendDis, double angle) {
        Set<EarthPoint3D> centerPoints = SpaceGeometryUtil.earthCubePeakDetail(point3D, distance, angle);
        HashSet<EarthPoint3D> batchPoints = new HashSet<EarthPoint3D>(centerPoints);
        centerPoints.forEach(point -> batchPoints.addAll(SpaceGeometryUtil.earthCubePeakDetail(new Point3D(point.getLng(), point.getLat(), point.getHeight()), extendDis, angle)));
        return batchPoints;
    }

    public static Set<EarthPoint3D> earthBatchPeakDetail(Point3D point3D, double distance, double extendDis) {
        return SpaceGeometryUtil.earthBatchPeakDetail(point3D, distance, extendDis, 0.0);
    }

    public static Set<EarthPoint3D> EarthBatchPeakDetailToWd(Point3D point3D, double distance, double angle, double step) {
        Set<EarthPoint3D> batchPoints = SpaceGeometryUtil.totalEarthBatchPeakDetailWithoutWd(point3D, distance, angle, step);
        batchPoints = batchPoints.stream().filter(a -> a.getX() > 0.0).collect(Collectors.toSet());
        return batchPoints;
    }

    public static Set<EarthPoint3D> totalEarthBatchPeakDetailWithoutWd(Point3D point3D, double distance, double angle, double step) {
        HashSet<EarthPoint3D> batchPoints = new HashSet<EarthPoint3D>();
        double h = point3D.getZ();
        HashSet xRange = CollUtil.newHashSet((Object[])new Double[]{distance, -distance});
        HashSet yRange = CollUtil.newHashSet((Object[])new Double[]{distance, -distance});
        HashSet zRange = CollUtil.newHashSet((Object[])new Double[]{point3D.getZ()});
        int section = Convert.toInt((Object)Math.ceil(distance / step));
        for (int index = 0; index < section; ++index) {
            xRange.add((double)index * step);
            xRange.add((double)(-index) * step);
            yRange.add((double)index * step);
            yRange.add((double)(-index) * step);
            zRange.add(h + (double)index * step);
            zRange.add(h - (double)index * step);
        }
        for (Double aDouble : xRange) {
            for (Double value : yRange) {
                for (Double item : zRange) {
                    double x = aDouble;
                    double y = value;
                    double z = item;
                    double dis = Math.sqrt(x * x + y * y);
                    double ag = Math.toDegrees(Math.atan2(Math.abs(y), x));
                    if (y > 0.0) {
                        batchPoints.add(new EarthPoint3D(LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle - ag, new Point3D(point3D.getX(), point3D.getY(), z), dis), x, y, z));
                        continue;
                    }
                    batchPoints.add(new EarthPoint3D(LngLatUtil.calLocationByDistanceAndLocationAndDirection(angle + ag, new Point3D(point3D.getX(), point3D.getY(), z), dis), x, y, z));
                }
            }
        }
        return batchPoints;
    }

    private SpaceGeometryUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

