/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.enums;

import cn.allbs.constant.ParamConstant;
import cn.allbs.enums.PollutantItemsLimitDayEnum;
import cn.allbs.enums.PollutionGas;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PollutantItemsLimitHourEnum {
    SO2(PollutionGas.a21026.toString(), PollutionGas.a21026.getMeaning(), "\u03bcg/m\u00b3", 1000.0, CollUtil.list((boolean)true, (Object[])new Integer[]{0, 150, 500, 650, 800})),
    NO2(PollutionGas.a21004.toString(), PollutionGas.a21004.getMeaning(), "\u03bcg/m\u00b3", 1000.0, CollUtil.list((boolean)true, (Object[])new Integer[]{0, 100, 200, 700, 1200, 2340, 3090, 3840})),
    CO(PollutionGas.a21005.toString(), PollutionGas.a21005.getMeaning(), "mg/m\u00b3", 1.0, CollUtil.list((boolean)true, (Object[])new Integer[]{0, 5, 10, 35, 60, 90, 120, 150})),
    O3("O3", "\u81ed\u6c27", "\u03bcg/m\u00b3", 1000.0, CollUtil.list((boolean)true, (Object[])new Integer[]{0, 160, 200, 300, 400, 800, 1000, 1200}));

    private final String code;
    private final String name;
    private final String unit;
    private final Double rate;
    private final List<Integer> sectionList;
    private static final Map<String, PollutantItemsLimitHourEnum> HOUR_ENUM_MAP;

    public static Double AirAqiCountRealTime(String code, double cp) {
        if (!HOUR_ENUM_MAP.containsKey(code) || cp <= 0.0) {
            return null;
        }
        if (SO2.getCode().equals(code) && cp > (double)((Integer)PollutantItemsLimitHourEnum.SO2.sectionList.stream().max(Integer::compareTo).get()).intValue()) {
            return PollutantItemsLimitDayEnum.AirAqiCountDayAverage(SO2.getCode(), cp);
        }
        List<Integer> sectionList = HOUR_ENUM_MAP.get(code).getSectionList();
        cp *= HOUR_ENUM_MAP.get(code).getRate().doubleValue();
        for (int i = 0; i < sectionList.size(); ++i) {
            if (!(cp <= (double)sectionList.get(i).intValue())) continue;
            return NumberUtil.round((BigDecimal)BigDecimal.valueOf(ParamConstant.I_AQI.get(i) - ParamConstant.I_AQI.get(i - 1)).divide(BigDecimal.valueOf(sectionList.get(i) - sectionList.get(i - 1)), 2, 5).multiply(BigDecimal.valueOf(cp - (double)sectionList.get(i - 1).intValue())).add(BigDecimal.valueOf(ParamConstant.I_AQI.get(i - 1).intValue())), (int)2).doubleValue();
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public Double getRate() {
        return this.rate;
    }

    public List<Integer> getSectionList() {
        return this.sectionList;
    }

    private PollutantItemsLimitHourEnum(String code, String name, String unit, Double rate, List<Integer> sectionList) {
        this.code = code;
        this.name = name;
        this.unit = unit;
        this.rate = rate;
        this.sectionList = sectionList;
    }

    static {
        HOUR_ENUM_MAP = new HashMap<String, PollutantItemsLimitHourEnum>(7);
        for (PollutantItemsLimitHourEnum hourEnum : PollutantItemsLimitHourEnum.values()) {
            HOUR_ENUM_MAP.put(hourEnum.getCode(), hourEnum);
        }
    }
}

