/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.enums;

import cn.allbs.enums.CompareWayEnum;
import cn.allbs.enums.PollutionWater;
import cn.allbs.enums.WaterLevelEnum;
import cn.hutool.core.collection.CollUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum WaterQualityItemEnum {
    PH(PollutionWater.w01001.toString(), PollutionWater.w01001.getMeaning(), "\u65e0\u91cf\u7eb2", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{6.0, 9.0}), CompareWayEnum.SECTION, null),
    DO(PollutionWater.w01009.toString(), PollutionWater.w01009.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{7.5, 6.0, 5.0, 3.0, 2.0}), CompareWayEnum.GATHER_THAN, null),
    COD_MN(PollutionWater.w01019.toString(), PollutionWater.w01019.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{2.0, 4.0, 6.0, 10.0, 15.0}), CompareWayEnum.LESS_THAN, null),
    COD(PollutionWater.w01018.toString(), PollutionWater.w01018.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{15.0, 15.0, 20.0, 30.0, 40.0}), CompareWayEnum.LESS_THAN, null),
    BOD5(PollutionWater.w01017.toString(), PollutionWater.w01017.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{3.0, 3.0, 4.0, 6.0, 10.0}), CompareWayEnum.LESS_THAN, null),
    NH3N(PollutionWater.w21003.toString(), PollutionWater.w21003.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.15, 0.5, 1.0, 1.5, 2.0}), CompareWayEnum.LESS_THAN, null),
    TP(PollutionWater.w21011.toString(), PollutionWater.w21011.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.02, 0.1, 0.2, 0.3, 0.4}), CompareWayEnum.LESS_THAN, CollUtil.list((boolean)true, (Object[])new Double[]{0.01, 0.025, 0.05, 0.1, 0.2})),
    TN(PollutionWater.w21001.toString(), PollutionWater.w21001.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.2, 0.5, 1.0, 1.5, 2.0}), CompareWayEnum.LESS_THAN, null),
    CU(PollutionWater.w20138.toString(), PollutionWater.w20138.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.01, 1.0, 1.0, 1.0, 1.0}), CompareWayEnum.LESS_THAN, null),
    ZN(PollutionWater.w20139.toString(), PollutionWater.w20139.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.05, 1.0, 1.0, 2.0, 2.0}), CompareWayEnum.LESS_THAN, null),
    F_IDE(PollutionWater.w21017.toString(), PollutionWater.w21017.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{1.0, 1.0, 1.0, 1.5, 1.5}), CompareWayEnum.LESS_THAN, null),
    SE(PollutionWater.w20140.toString(), PollutionWater.w20140.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.01, 0.01, 0.01, 0.02, 0.02}), CompareWayEnum.LESS_THAN, null),
    ARSENIC(PollutionWater.w20141.toString(), PollutionWater.w20141.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.05, 0.05, 0.05, 0.1, 0.1}), CompareWayEnum.LESS_THAN, null),
    MERCURY(PollutionWater.w20142.toString(), PollutionWater.w20142.getMeaning(), "mg/L", 0.001, CollUtil.list((boolean)true, (Object[])new Double[]{5.0E-5, 5.0E-5, 1.0E-4, 0.001, 0.001}), CompareWayEnum.LESS_THAN, null),
    CD(PollutionWater.w20143.toString(), PollutionWater.w20143.getMeaning(), "mg/L", 0.001, CollUtil.list((boolean)true, (Object[])new Double[]{0.001, 0.005, 0.005, 0.005, 0.01}), CompareWayEnum.LESS_THAN, null),
    CR_VI(PollutionWater.w20117.toString(), PollutionWater.w20117.getMeaning(), "mg/L", 0.001, CollUtil.list((boolean)true, (Object[])new Double[]{0.01, 0.05, 0.05, 0.05, 0.1}), CompareWayEnum.LESS_THAN, null),
    PL(PollutionWater.w20144.toString(), PollutionWater.w20144.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.01, 0.01, 0.05, 0.05, 0.1}), CompareWayEnum.LESS_THAN, null),
    CY(PollutionWater.w21016.toString(), PollutionWater.w21016.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.005, 0.05, 0.2, 0.2, 0.2}), CompareWayEnum.LESS_THAN, null),
    VP(PollutionWater.w23002.toString(), PollutionWater.w23002.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.002, 0.002, 0.005, 0.01, 0.1}), CompareWayEnum.LESS_THAN, null),
    PE(PollutionWater.w22001.toString(), PollutionWater.w22001.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.05, 0.05, 0.05, 0.5, 1.0}), CompareWayEnum.LESS_THAN, null),
    AS(PollutionWater.w19002.toString(), PollutionWater.w19002.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.2, 0.2, 0.2, 0.3, 0.3}), CompareWayEnum.LESS_THAN, null),
    S_IDE(PollutionWater.w21019.toString(), PollutionWater.w21019.getMeaning(), "mg/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{0.05, 0.1, 0.2, 0.5, 1.0}), CompareWayEnum.LESS_THAN, null),
    FC(PollutionWater.w02003.toString(), PollutionWater.w02003.getMeaning(), "\u4e2a/L", 1.0, CollUtil.list((boolean)true, (Object[])new Double[]{200.0, 2000.0, 10000.0, 20000.0, 40000.0}), CompareWayEnum.LESS_THAN, null);

    private final String code;
    private final String pollutantName;
    private final String unit;
    private final Double rate;
    private final List<Double> sectionList;
    private final CompareWayEnum compareWa;
    private final List<Double> standbySectionList;
    private static final Map<String, WaterQualityItemEnum> WATER_QUALITY_MAP;

    public static Integer waterLevelCount(String code, boolean isLakeOrReservoir, double v) {
        block10: {
            if (!WATER_QUALITY_MAP.containsKey(code)) break block10;
            WaterQualityItemEnum waterItem = WATER_QUALITY_MAP.get(code);
            List<Double> sList = waterItem.getSectionList();
            if (isLakeOrReservoir && CollUtil.isNotEmpty(waterItem.getStandbySectionList())) {
                sList = waterItem.getStandbySectionList();
            }
            Double last = sList.get(sList.size() - 1);
            if (CompareWayEnum.SECTION.equals((Object)waterItem.compareWa)) {
                if (v < sList.get(0) || v > last) {
                    return WaterLevelEnum.VI.getLevel();
                }
            } else if (CompareWayEnum.GATHER_THAN.equals((Object)waterItem.compareWa)) {
                if (v < last) {
                    return WaterLevelEnum.VI.getLevel();
                }
                for (int i = 0; i < sList.size(); ++i) {
                    if (!(v >= sList.get(i))) continue;
                    return i + 1;
                }
            } else {
                if (v > last) {
                    return WaterLevelEnum.VI.getLevel();
                }
                for (int i = 0; i < sList.size(); ++i) {
                    if (!(v <= sList.get(i))) continue;
                    return i + 1;
                }
            }
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getPollutantName() {
        return this.pollutantName;
    }

    public String getUnit() {
        return this.unit;
    }

    public Double getRate() {
        return this.rate;
    }

    public List<Double> getSectionList() {
        return this.sectionList;
    }

    public CompareWayEnum getCompareWa() {
        return this.compareWa;
    }

    public List<Double> getStandbySectionList() {
        return this.standbySectionList;
    }

    private WaterQualityItemEnum(String code, String pollutantName, String unit, Double rate, List<Double> sectionList, CompareWayEnum compareWa, List<Double> standbySectionList) {
        this.code = code;
        this.pollutantName = pollutantName;
        this.unit = unit;
        this.rate = rate;
        this.sectionList = sectionList;
        this.compareWa = compareWa;
        this.standbySectionList = standbySectionList;
    }

    static {
        WATER_QUALITY_MAP = new HashMap<String, WaterQualityItemEnum>(32);
        for (WaterQualityItemEnum water : WaterQualityItemEnum.values()) {
            WATER_QUALITY_MAP.put(water.getCode(), water);
        }
    }
}

