/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.constant.ParamConstant;
import cn.allbs.enums.PollutantItemsLimitDayEnum;
import cn.allbs.enums.PollutantItemsLimitHourEnum;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class AqiUtil {
    public static Map<String, Object> countRealAqi(Map<String, Double> pollutantValueMap, boolean isDay) {
        HashMap<String, Object> aqiMap = new HashMap<String, Object>(5);
        if (MapUtil.isNotEmpty(pollutantValueMap)) {
            double maxAqi = 0.0;
            ArrayList<String> primaryP = new ArrayList<String>();
            ArrayList<String> exP = new ArrayList<String>();
            for (Map.Entry<String, Double> entry : pollutantValueMap.entrySet()) {
                Double aqi;
                String k = entry.getKey();
                Double v = entry.getValue();
                if (v == null || (aqi = isDay ? PollutantItemsLimitDayEnum.AirAqiCountDayAverage(k, v) : PollutantItemsLimitHourEnum.AirAqiCountRealTime(k, v)) == null) continue;
                if (aqi > maxAqi) {
                    maxAqi = aqi;
                    primaryP.clear();
                }
                if (aqi > (double)ParamConstant.PRIMARY_POLLUTANT_MIN_LIMIT.intValue()) {
                    primaryP.add(k);
                }
                if (!(aqi > (double)ParamConstant.EXCESSIVE_POLLUTANT_MIN_LIMIT.intValue())) continue;
                exP.add(k);
            }
            if (maxAqi == 0.0) {
                return null;
            }
            aqiMap.put("aqi", maxAqi);
            aqiMap.put("primaryP", CollUtil.join(primaryP, (CharSequence)","));
            aqiMap.put("excessiveP", CollUtil.join(exP, (CharSequence)","));
        }
        return aqiMap;
    }

    private AqiUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

