/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.model.EarthPoint3D;
import cn.allbs.model.Point3D;
import cn.allbs.model.SpacePoint;
import cn.allbs.utils.EvaporationUtil;
import cn.allbs.utils.GaussUtil;
import cn.allbs.utils.HorizontalJetFireUtil;
import cn.allbs.utils.LngLatUtil;
import cn.allbs.utils.PoolFireUtil;
import cn.allbs.utils.SpaceGeometryUtil;
import cn.allbs.utils.VaporCloudExplosionUtil;
import cn.allbs.utils.VesselExplosionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import java.util.HashSet;
import java.util.Set;

public final class ModelUtil {
    public static Set<SpacePoint> poolFire(double g, double p0, double n, double hc, double m, double d, double lng, double lat, double height, double distance, double extendDistance) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<Point3D> points = SpaceGeometryUtil.earthBatchPeak(centerPoint, distance, extendDistance);
        points.forEach(a -> {
            if (a.getZ() < 0.0) {
                a.setZ(0.0);
            }
            double x = LngLatUtil.getDistance(a.getX(), a.getY(), centerPoint.getX(), centerPoint.getY());
            double c = PoolFireUtil.count(n, hc, x, m, p0, g, d);
            poolFirePoints.add(new SpacePoint((Point3D)a, c));
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> horizontalFire(double hc, double m, double lng, double lat, double height, double distance, double extendDistance) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<Point3D> points = SpaceGeometryUtil.earthBatchPeak(centerPoint, distance, extendDistance);
        points.forEach(a -> {
            if (a.getZ() < 0.0) {
                a.setZ(0.0);
            }
            double x = LngLatUtil.getDistance(a.getX(), a.getY(), centerPoint.getX(), centerPoint.getY());
            double c = HorizontalJetFireUtil.count(hc, x, m);
            poolFirePoints.add(new SpacePoint((Point3D)a, c));
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> vesselExplosion(double p, double v, double lng, double lat, double height, double distance, double extendDistance) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<Point3D> points = SpaceGeometryUtil.earthBatchPeak(centerPoint, distance, extendDistance);
        points.forEach(a -> {
            if (a.getZ() < 0.0) {
                a.setZ(0.0);
            }
            double x = LngLatUtil.getDistance(a.getX(), a.getY(), centerPoint.getX(), centerPoint.getY());
            double c = VesselExplosionUtil.count(p, v, x);
            poolFirePoints.add(new SpacePoint((Point3D)a, c));
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> vaporCloudExplosion(Double qm, Double cp, Double tt, Double tb, Double hv, Double a1, Double t0, Double h, Double t, Double u, Double r, Double m, Double t1, Double t2, Double t3, double q, double lng, double lat, double height, double distance, double extendDistance) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<Point3D> points = SpaceGeometryUtil.earthBatchPeak(centerPoint, distance, extendDistance);
        points.forEach(a -> {
            if (a.getZ() < 0.0) {
                a.setZ(0.0);
            }
            double x = LngLatUtil.getDistance(a.getX(), a.getY(), centerPoint.getX(), centerPoint.getY());
            double w = EvaporationUtil.totalEvaporation(qm, cp, tt, tb, hv, a1, t0, h, t, u, r, m, t1, t2, t3);
            double c = VaporCloudExplosionUtil.count(w, q, x);
            poolFirePoints.add(new SpacePoint((Point3D)a, c));
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> gaussSmokeRegiment(double ws, double t, double q, double angle, double lng, double lat, double height, double distance, double step) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<EarthPoint3D> points = SpaceGeometryUtil.totalEarthBatchPeakDetailWithoutWd(centerPoint, distance, angle, step);
        points.forEach(a -> {
            if (a.getHeight() < 0.0) {
                a.setZ(-(distance + a.getHeight()));
                a.setHeight(0.0);
            }
            if (a.getX() == 0.0) {
                return;
            }
            double c = NumberUtil.round((double)GaussUtil.smokeConcentration(q, ws, t, Math.abs(a.getX()), Math.abs(a.getY()), Math.abs(a.getZ())), (int)3).doubleValue();
            if (ObjectUtil.isNotNull((Object)c) && c != 0.0) {
                poolFirePoints.add(new SpacePoint((EarthPoint3D)a, c));
            }
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> gaussPlumeWithFactor(double ws, double q, Integer l, double angle, double h, double lng, double lat, double height, double distance, double step) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<EarthPoint3D> points = SpaceGeometryUtil.EarthBatchPeakDetailToWd(centerPoint, distance, angle, step);
        points.forEach(a -> {
            if (a.getHeight() < 0.0) {
                a.setZ(-(distance + a.getHeight()));
                a.setHeight(0.0);
                double c = NumberUtil.round((double)GaussUtil.allGroundReflection(q, ws, h, a.getX(), Math.abs(a.getY()), l), (int)3).doubleValue();
                poolFirePoints.add(new SpacePoint((EarthPoint3D)a, c));
            } else {
                double c = NumberUtil.round((double)GaussUtil.highPowerContinuousDiffusion(q, ws, h, a.getX(), Math.abs(a.getY()), a.getZ(), l), (int)3).doubleValue();
                poolFirePoints.add(new SpacePoint((EarthPoint3D)a, c));
            }
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> gaussPlumeWithoutFactor(double q, double u, double angle, double h, double lng, double lat, double distance, double step) {
        Point3D centerPoint = new Point3D(lng, lat, h);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<EarthPoint3D> points = SpaceGeometryUtil.EarthBatchPeakDetailToWd(centerPoint, distance, angle, step);
        points.forEach(a -> {
            double c;
            if (a.getHeight() < 0.0) {
                a.setZ(-(distance + a.getHeight()));
                a.setHeight(0.0);
            }
            if ((c = NumberUtil.round((double)GaussUtil.powerContinuousDiffusionWithoutSigma(q, u, h, Math.abs(a.getX()), Math.abs(a.getY()), Math.abs(a.getZ())), (int)3).doubleValue()) != 0.0) {
                poolFirePoints.add(new SpacePoint((EarthPoint3D)a, c));
            }
        });
        return poolFirePoints;
    }

    private ModelUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

