/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.enums;

public enum MathExtentEnum {
    NO_LIMIT("(-\u221e, +\u221e)=R", "1=1"),
    IN_SECTION_LEFT_RIGHT("[a,b]:{x\u2208R:a\u2264x\u2264b}", "[%s,%s]"),
    IN_SECTION_LEFT_ONLY("[a,b)={x\u2208R:a\u2264x<b}", "[%s,%s)"),
    IN_SECTION_RIGHT_ONLY("(a,b]={x\u2208R:a<x\u2264b}", "(%s,%s]"),
    IN_SECTION("(a,b)={x\u2208R:a<x<b}", "(%s,%s)"),
    LEFT_CLOSED("[a,+\u221e)={x\u2208R:x\u2265a}", "[%s,+\u221e)"),
    LEFT_OPEN("(a,+\u221e)={x\u2208R:x>a}", "(%s,+\u221e)"),
    RIGHT_CLOSED("(-\u221e, b]={x\u2208R:x\u2264b}", "(-\u221e, %s]"),
    RIGHT_OPEN("(-\u221e, b)={x\u2208R:x<b}", "(-\u221e, %s)");

    private final String pattern;
    private final String expression;

    public static String getEqExpressAllClose(Double min, Double max) {
        if (min != null && max != null) {
            return String.format(IN_SECTION_LEFT_RIGHT.getExpression(), min, max);
        }
        if (min != null) {
            return String.format(LEFT_CLOSED.getExpression(), min);
        }
        if (max != null) {
            return String.format(RIGHT_CLOSED.getExpression(), max);
        }
        return NO_LIMIT.getExpression();
    }

    public static String getEqExpressAllOpen(Double min, Double max) {
        if (min != null && max != null) {
            return String.format(IN_SECTION.getExpression(), min, max);
        }
        if (min != null) {
            return String.format(LEFT_OPEN.getExpression(), min);
        }
        if (max != null) {
            return String.format(RIGHT_OPEN.getExpression(), max);
        }
        return NO_LIMIT.getExpression();
    }

    public static String getEqExpressLeftOpenOnly(Double min, Double max) {
        if (min != null && max != null) {
            return String.format(IN_SECTION_RIGHT_ONLY.getExpression(), min, max);
        }
        if (min != null) {
            return String.format(LEFT_OPEN.getExpression(), min);
        }
        if (max != null) {
            return String.format(RIGHT_CLOSED.getExpression(), max);
        }
        return NO_LIMIT.getExpression();
    }

    public static String getEqExpressRightOpenOnly(Double min, Double max) {
        if (min != null && max != null) {
            return String.format(IN_SECTION_LEFT_ONLY.getExpression(), min, max);
        }
        if (min != null) {
            return String.format(LEFT_CLOSED.getExpression(), min);
        }
        if (max != null) {
            return String.format(RIGHT_OPEN.getExpression(), max);
        }
        return NO_LIMIT.getExpression();
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getExpression() {
        return this.expression;
    }

    private MathExtentEnum(String pattern, String expression) {
        this.pattern = pattern;
        this.expression = expression;
    }
}

