/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.enums;

import cn.allbs.constant.ParamConstant;
import cn.allbs.enums.PollutantItemsLimitHourEnum;
import cn.allbs.enums.PollutionGas;
import cn.allbs.utils.CommonUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PollutantItemsLimitDayEnum {
    SO2(PollutionGas.a21026.toString(), PollutionGas.a21026.getMeaning(), "\u03bcg/m\u00b3", 1000.0, CommonUtil.list(true, 0, 50, 150, 475, 800, 1600, 2100, 2620)),
    NO2(PollutionGas.a21004.toString(), PollutionGas.a21004.getMeaning(), "\u03bcg/m\u00b3", 1000.0, CommonUtil.list(true, 0, 40, 80, 180, 280, 565, 750, 940)),
    PM10(PollutionGas.a34002.toString(), PollutionGas.a34002.getMeaning(), "\u03bcg/m\u00b3", 0.001, CommonUtil.list(true, 0, 50, 150, 250, 350, 420, 500, 600)),
    CO(PollutionGas.a21005.toString(), PollutionGas.a21005.getMeaning(), "mg/m\u00b3", 1.0, CommonUtil.list(true, 0, 2, 14, 14, 24, 36, 48, 60)),
    O3("O3", "\u81ed\u6c27", "\u03bcg/m\u00b3", 1000.0, CommonUtil.list(true, 0, 100, 160, 215, 265, 800)),
    PM25(PollutionGas.a34004.toString(), PollutionGas.a34004.getMeaning(), "\u03bcg/m\u00b3", 0.001, CommonUtil.list(true, 0, 35, 75, 115, 150, 250, 350, 500));

    private final String code;
    private final String name;
    private final String unit;
    private final Double rate;
    private final List<Integer> sectionList;
    private static final Map<String, PollutantItemsLimitDayEnum> DAY_ENUM_MAP;

    public static Double AirAqiCountDayAverage(String code, double cp) {
        if (!DAY_ENUM_MAP.containsKey(code) || cp <= 0.0) {
            return null;
        }
        if (O3.getCode().equals(code) && cp > (double)((Integer)PollutantItemsLimitDayEnum.O3.sectionList.stream().max(Integer::compareTo).get()).intValue()) {
            return PollutantItemsLimitHourEnum.AirAqiCountRealTime(O3.getCode(), cp);
        }
        List<Integer> sectionList = DAY_ENUM_MAP.get(code).getSectionList();
        cp = DAY_ENUM_MAP.get(code).getRate();
        for (int i = 0; i < sectionList.size(); ++i) {
            if (!(cp < (double)sectionList.get(i).intValue())) continue;
            return CommonUtil.round(BigDecimal.valueOf(ParamConstant.I_AQI.get(i) - ParamConstant.I_AQI.get(i - 1)).divide(BigDecimal.valueOf(sectionList.get(i) - sectionList.get(i - 1)), 2, 5).multiply(BigDecimal.valueOf(cp - (double)sectionList.get(i - 1).intValue())).add(BigDecimal.valueOf(ParamConstant.I_AQI.get(i - 1).intValue())), 2).doubleValue();
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public Double getRate() {
        return this.rate;
    }

    public List<Integer> getSectionList() {
        return this.sectionList;
    }

    private PollutantItemsLimitDayEnum(String code, String name, String unit, Double rate, List<Integer> sectionList) {
        this.code = code;
        this.name = name;
        this.unit = unit;
        this.rate = rate;
        this.sectionList = sectionList;
    }

    static {
        DAY_ENUM_MAP = new HashMap<String, PollutantItemsLimitDayEnum>(9);
        for (PollutantItemsLimitDayEnum dayEnum : PollutantItemsLimitDayEnum.values()) {
            DAY_ENUM_MAP.put(dayEnum.getCode(), dayEnum);
        }
    }
}

