/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class AsciiUtil {
    public static String bytes2HexString(byte[] b) {
        StringBuilder r = new StringBuilder();
        for (byte value : b) {
            String hex = Integer.toHexString(value & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            r.append(hex.toUpperCase());
        }
        return r.toString();
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte[] hexString2Bytes(String hex) {
        if (hex == null || hex.equals("")) {
            return null;
        }
        if (hex.length() % 2 != 0) {
            return null;
        }
        hex = hex.toUpperCase();
        int len = hex.length() / 2;
        byte[] b = new byte[len];
        char[] hc = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int p = 2 * i;
            b[i] = (byte)(AsciiUtil.charToByte(hc[p]) << 4 | AsciiUtil.charToByte(hc[p + 1]));
        }
        return b;
    }

    public static String bytes2String(byte[] b) throws Exception {
        return AsciiUtil.bytes2String(b, StandardCharsets.UTF_8);
    }

    public static String bytes2String(byte[] b, Charset charset) throws Exception {
        return new String(b, charset);
    }

    public static byte[] string2Bytes(String s) {
        return s.getBytes();
    }

    public static String hex2String(String hex) throws Exception {
        return AsciiUtil.bytes2String(AsciiUtil.hexString2Bytes(hex));
    }

    public static String string2HexString(String s) {
        return AsciiUtil.bytes2HexString(AsciiUtil.string2Bytes(s));
    }

    public static byte[] getBytes(char[] chars) {
        Charset cs = StandardCharsets.UTF_8;
        CharBuffer cb = CharBuffer.allocate(chars.length);
        cb.put(chars);
        cb.flip();
        ByteBuffer bb = cs.encode(cb);
        return bb.array();
    }

    public static char[] getChars(byte[] bytes) {
        Charset cs = StandardCharsets.UTF_8;
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes).flip();
        CharBuffer cb = cs.decode(bb);
        return cb.array();
    }

    public static byte[] charToBytes(char c) {
        byte[] b = new byte[]{(byte)((c & 0xFF00) >> 8), (byte)(c & 0xFF)};
        return b;
    }

    public static char byteToChar(byte[] b) {
        int hi = (b[0] & 0xFF) << 8;
        int lo = b[1] & 0xFF;
        return (char)(hi | lo);
    }

    public static byte[] strToBytes(String str) {
        String[] strs = str.trim().split(" ");
        byte[] b = new byte[strs.length];
        if (strs.length == 0) {
            return b;
        }
        for (int i = 0; i < strs.length; ++i) {
            b[i] = AsciiUtil.hexString2Bytes(strs[i])[0];
        }
        return b;
    }

    public static byte[] sumCheck(byte[] msg, int len) {
        long mSum = 0L;
        byte[] mByte = new byte[len];
        for (byte byteMsg : msg) {
            long mNum = (long)byteMsg >= 0L ? (long)byteMsg : (long)byteMsg + 256L;
            mSum += mNum;
        }
        for (int livCount = 0; livCount < len; ++livCount) {
            mByte[len - livCount - 1] = (byte)(mSum >> livCount * 8 & 0xFFL);
        }
        return mByte;
    }

    public static String gb18030ToUtf8(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer gb180303 = Charset.forName("GB18030").decode(byteBuffer);
        ByteBuffer utf8 = StandardCharsets.UTF_8.encode(gb180303);
        return new String(utf8.array()).trim();
    }

    public static byte[] utf8ToGb18030ByteArray(String str) {
        ByteBuffer gb18030 = Charset.forName("GB18030").encode(str);
        return gb18030.array();
    }

    public static String twoToSixteen(String s) {
        int data = Integer.valueOf(s, 2);
        return Integer.toHexString(data);
    }

    public static String tenToTwo(String num) {
        return Integer.toBinaryString(Integer.parseInt(num));
    }

    public static String sixteenToTen(String num) {
        BigInteger lngNum = new BigInteger(num, 16);
        return String.valueOf(lngNum.intValue());
    }

    public static String tenToSixteen(String str) {
        int data = Integer.parseInt(str);
        String preData = Integer.toHexString(data);
        return preData;
    }

    public static String gbkToUnicode(String str, String charsetName) {
        StringBuilder st = new StringBuilder();
        try {
            byte[] by;
            for (byte b : by = str.getBytes(charsetName)) {
                String strs = Integer.toHexString(b);
                if (strs.length() > 2) {
                    strs = strs.substring(strs.length() - 2);
                }
                st.append(strs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return st.toString();
    }

    public static String gbkToUnicode(String str) {
        return AsciiUtil.gbkToUnicode(str, Charset.defaultCharset().name());
    }

    public static String strToASCII(String str) {
        char[] ch;
        StringBuilder sb = new StringBuilder();
        for (char c : ch = str.toCharArray()) {
            String s = Integer.toHexString(c);
            sb.append(s);
        }
        return sb.toString();
    }

    public static int getHeight4FromShort(short data) {
        int height = (data & 0xF0) >> 4;
        return height;
    }

    public static int getHeight4FromByte(byte data) {
        int height = (data & 0xF0) >> 4;
        return height;
    }

    public static int getLow4FromShort(short data) {
        int low = data & 0xF;
        return low;
    }

    public static int getLow4FromByte(byte data) {
        int low = data & 0xF;
        return low;
    }

    public static short bytesToShort(byte[] bytes, ByteOrder byteOrder) {
        if (bytes.length == 1) {
            return (short)(bytes[0] & 0xFF);
        }
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return (short)(AsciiUtil.getLow4FromByte(bytes[0]) << 4 | AsciiUtil.getLow4FromByte(bytes[1]));
        }
        return (short)(AsciiUtil.getLow4FromByte(bytes[1]) << 4 | AsciiUtil.getLow4FromByte(bytes[0]));
    }

    public static short bytesToShort(byte[] bytes) {
        return AsciiUtil.bytesToShort(bytes, ByteOrder.LITTLE_ENDIAN);
    }

    public static short bytesToShort(byte[] bytes, ByteOrder byteOrder, int shift) {
        if (bytes.length == 1) {
            return (short)(bytes[0] & 0xFF);
        }
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return (short)(AsciiUtil.getLow4FromShort((short)(bytes[0] - shift)) << 4 | AsciiUtil.getLow4FromShort((short)(bytes[1] - shift)));
        }
        return (short)(AsciiUtil.getLow4FromShort((short)(bytes[1] - shift)) << 4 | AsciiUtil.getLow4FromShort((short)(bytes[0] - shift)));
    }

    public static short bytesToShort(byte[] bytes, int shift) {
        return AsciiUtil.bytesToShort(bytes, ByteOrder.LITTLE_ENDIAN, shift);
    }

    public static int crc16Checkout(char[] msg, int length) {
        int crc_reg = 65535;
        for (int i = 0; i < length; ++i) {
            crc_reg = crc_reg >> 8 ^ msg[i];
            for (int j = 0; j < 8; ++j) {
                int check = crc_reg & 1;
                crc_reg >>= 1;
                if (check != 1) continue;
                crc_reg ^= 0xA001;
            }
        }
        return crc_reg;
    }

    public static int crc16CheckoutByte(byte[] msg, int length) {
        int crc_reg = 65535;
        for (int i = 0; i < length; ++i) {
            crc_reg = crc_reg >> 8 ^ msg[i];
            for (int j = 0; j < 8; ++j) {
                int check = crc_reg & 1;
                crc_reg >>= 1;
                if (check != 1) continue;
                crc_reg ^= 0xA001;
            }
        }
        return crc_reg;
    }

    public static char[] binaryTrans(byte[] bs) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bs) {
            sb.append(String.format("%08d", Long.valueOf(Integer.toBinaryString(b))));
        }
        return sb.reverse().toString().toCharArray();
    }

    public static short bytesToCount(byte[] bytes) {
        return AsciiUtil.bytesToCount(bytes, ByteOrder.LITTLE_ENDIAN);
    }

    public static short bytesToCount(byte[] bytes, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return (short)(bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8);
        }
        return (short)(bytes[1] & 0xFF | (bytes[0] & 0xFF) << 8);
    }

    public static int crcModbusCheck(byte[] bytes) {
        int CRC = 65535;
        int POLYNOMIAL = 40961;
        for (int i = 0; i < bytes.length; ++i) {
            CRC ^= bytes[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((CRC & 1) != 0) {
                    CRC >>= 1;
                    CRC ^= POLYNOMIAL;
                    continue;
                }
                CRC >>= 1;
            }
        }
        return CRC;
    }
}

