/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import com.google.common.base.Strings;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommonUtil {
    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (CommonUtil.isEmpty(values)) {
            return CommonUtil.list(isLinked, new Object[0]);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CommonUtil.isEmpty(collection);
    }

    @SafeVarargs
    public static <T> HashSet<T> set(boolean isSorted, T ... ts) {
        if (null == ts) {
            return isSorted ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        Collections.addAll(set, ts);
        return set;
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... ts) {
        return CommonUtil.set(false, ts);
    }

    public static String concat(boolean isNullToEmpty, CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        CharSequence[] var3 = strs;
        int var4 = strs.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            CharSequence str = var3[var5];
            sb.append(isNullToEmpty ? CommonUtil.nullToEmpty(str) : str);
        }
        return sb.toString();
    }

    public static String nullToEmpty(CharSequence str) {
        return CommonUtil.nullToDefault(str, "");
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        return collection.toArray(CommonUtil.newArray(componentType, 0));
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static Object[] newArray(int newSize) {
        return new Object[newSize];
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && !map.isEmpty();
    }

    public static boolean isNotNull(Object obj) {
        return null != obj;
    }

    public static boolean isValidIfNumber(Object obj) {
        return !(obj instanceof Number) || CommonUtil.isValidNumber((Number)obj);
    }

    public static boolean isValidNumber(Number number) {
        if (number instanceof Double) {
            return !((Double)number).isInfinite() && !((Double)number).isNaN();
        }
        if (!(number instanceof Float)) {
            return true;
        }
        return !((Float)number).isInfinite() && !((Float)number).isNaN();
    }

    public static boolean hasEmpty(Double ... args) {
        if (CommonUtil.isNotEmpty(args)) {
            Double[] var1 = args;
            int var2 = args.length;
            for (int var3 = 0; var3 < var2; ++var3) {
                Double element = var1[var3];
                if (element != null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAllNotEmpty(Double ... args) {
        return !CommonUtil.hasEmpty(args);
    }

    public static BigDecimal round(double v, int scale) {
        return CommonUtil.round(v, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(double v, int scale, RoundingMode roundingMode) {
        return CommonUtil.round(Double.toString(v), scale, roundingMode);
    }

    public static BigDecimal round(String numberStr, int scale, RoundingMode roundingMode) {
        if (scale < 0) {
            scale = 0;
        }
        return CommonUtil.round(CommonUtil.toBigDecimal(numberStr), scale, roundingMode);
    }

    public static BigDecimal toBigDecimal(String number) {
        try {
            number = CommonUtil.parseNumber(number).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Strings.isNullOrEmpty((String)number) ? BigDecimal.ZERO : new BigDecimal(number);
    }

    public static Number parseNumber(String numberStr) throws NumberFormatException {
        try {
            return NumberFormat.getInstance().parse(numberStr);
        }
        catch (ParseException var3) {
            NumberFormatException nfe = new NumberFormatException(var3.getMessage());
            nfe.initCause(var3);
            throw nfe;
        }
    }

    public static BigDecimal round(BigDecimal number, int scale) {
        return CommonUtil.round(number, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        if (null == number) {
            number = BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return number.setScale(scale, roundingMode);
    }
}

