/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.utils.CommonUtil;

public final class EvaporationUtil {
    public static Double flash(double qm, double cp, double tt, double tb, double hv) {
        return qm * cp * (tt - tb) / hv;
    }

    public static Double heatOfEvaporation(double a1, double t0, double tb, double h, double t) {
        return 1.1 * a1 * (t0 - tb) / (h * Math.sqrt(4.0 * Math.pow(10.0, -7.0) * t));
    }

    public static Double qualityOfEvaporation(double t0, double u, double r, double m) {
        return 0.05 * m / (8.314 * t0) * Math.pow(u, 3.5) * Math.pow(r, 9.0);
    }

    public static Double totalEvaporation(Double qm, Double cp, Double tt, Double tb, Double hv, Double a1, Double t0, Double h, Double t, Double u, Double r, Double m, Double t1, Double t2, Double t3) {
        double total = 0.0;
        if (CommonUtil.isAllNotEmpty(qm, cp, tt, tb, hv, t1)) {
            total += EvaporationUtil.onlyFlash(qm, cp, tt, tb, hv, t1).doubleValue();
        }
        if (CommonUtil.isAllNotEmpty(a1, t0, h, t, t2, tb)) {
            total += EvaporationUtil.onlyHeatOfEvaporation(a1, t0, h, t, t2, tb).doubleValue();
        }
        if (CommonUtil.isAllNotEmpty(t0, u, r, m, t3)) {
            total += EvaporationUtil.onlyQualityOfEvaporation(t0, u, r, m, t3).doubleValue();
        }
        return total;
    }

    public static Double onlyFlash(double qm, double cp, double tt, double tb, double hv, double t1) {
        return EvaporationUtil.flash(qm, cp, tt, tb, hv) * t1;
    }

    public static Double onlyHeatOfEvaporation(double a1, double t0, double h, double t, double t2, double tb) {
        return EvaporationUtil.heatOfEvaporation(a1, t0, tb, h, t) * t2;
    }

    public static Double onlyQualityOfEvaporation(double t0, double u, double r, double m, double t3) {
        return EvaporationUtil.qualityOfEvaporation(t0, u, r, m) * t3;
    }

    private EvaporationUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

