/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.JBF293K.enums;

import cn.allbs.utils.JBF293K.format.data.AbstractParser;
import cn.allbs.utils.JBF293K.format.data.CommonAlarmParser;
import cn.allbs.utils.JBF293K.format.data.HeartParser;
import cn.allbs.utils.JBF293K.format.data.MultiLineAlarmParser;
import cn.allbs.utils.JBF293K.format.data.SimulationAlarmParser;
import cn.allbs.utils.JBF293K.format.data.VersionParser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class AlarmEnum
extends Enum<AlarmEnum> {
    public static final /* enum */ AlarmEnum CONTROLLER_HEART;
    public static final /* enum */ AlarmEnum CONTROLLER_NORMAL;
    public static final /* enum */ AlarmEnum CONTROLLER_BREAK;
    public static final /* enum */ AlarmEnum CONTROLLER_RESET;
    public static final /* enum */ AlarmEnum CONTROLLER_MUFFLING;
    public static final /* enum */ AlarmEnum FIRE_ALARM;
    public static final /* enum */ AlarmEnum FAULT;
    public static final /* enum */ AlarmEnum FAIL_BACK;
    public static final /* enum */ AlarmEnum CIRCUIT_FAILURE;
    public static final /* enum */ AlarmEnum LOOP_FAILURE_RECOVERY;
    public static final /* enum */ AlarmEnum START_AUTOMATICALLY;
    public static final /* enum */ AlarmEnum AUTOMATIC_STOP;
    public static final /* enum */ AlarmEnum START_MANUALLY;
    public static final /* enum */ AlarmEnum STOP_MANUALLY;
    public static final /* enum */ AlarmEnum THE_DEVICE_ANSWERS;
    public static final /* enum */ AlarmEnum ANSWER_REVOCATION;
    public static final /* enum */ AlarmEnum PART_ISOLATION;
    public static final /* enum */ AlarmEnum PART_ISOLATION_IS_REVOKED;
    public static final /* enum */ AlarmEnum MULTI_LINE_MANUAL_START;
    public static final /* enum */ AlarmEnum multi_line_manual_stop;
    public static final /* enum */ AlarmEnum MULTI_LINE_ANSWER;
    public static final /* enum */ AlarmEnum MULTI_LINE_STOP_ANSWERING;
    public static final /* enum */ AlarmEnum MULTI_LINE_AUTO_START;
    public static final /* enum */ AlarmEnum MULTI_LINE_AUTOMATIC_STOP;
    public static final /* enum */ AlarmEnum MULTI_LINE_AUTO_START_DELAY;
    public static final /* enum */ AlarmEnum MULTI_LINE_RESPONSE_IS_MISSING;
    public static final /* enum */ AlarmEnum MULTI_LINE_LINE_FAILURE;
    public static final /* enum */ AlarmEnum MULTI_LINE_LINE_FAILURE_RECOVERY;
    public static final /* enum */ AlarmEnum ANALOG_ALARM;
    public static final /* enum */ AlarmEnum REGULATORY_ALARMS;
    public static final /* enum */ AlarmEnum REGULATORY_ALARM_REVOCATION;
    public static final Map<Integer, AlarmEnum> ALARM_MAP;
    private final String desc;
    private final short circuit;
    private final String count;
    private final int[] code;
    private static final /* synthetic */ AlarmEnum[] $VALUES;

    public static AlarmEnum[] values() {
        return (AlarmEnum[])$VALUES.clone();
    }

    public static AlarmEnum valueOf(String name) {
        return Enum.valueOf(AlarmEnum.class, name);
    }

    public abstract AbstractParser execute(InputStream var1);

    private AlarmEnum(String desc, int ... i) {
        this.circuit = 0;
        this.count = null;
        this.desc = desc;
        this.code = i;
    }

    private AlarmEnum(String desc, short circuit, int ... i) {
        this.desc = desc;
        this.circuit = circuit;
        this.count = null;
        this.code = i;
    }

    private AlarmEnum(String desc, short circuit, String param, int ... i) {
        this.desc = desc;
        this.circuit = circuit;
        this.count = param;
        this.code = i;
    }

    public String getDesc() {
        return this.desc;
    }

    public short getCircuit() {
        return this.circuit;
    }

    public String getCount() {
        return this.count;
    }

    public int[] getCode() {
        return this.code;
    }

    static {
        AlarmEnum[] alarmEnums;
        CONTROLLER_HEART = new AlarmEnum("\u63a7\u5236\u5668\u5fc3\u8df3", new int[]{0, 105}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new HeartParser(ins);
            }
        };
        CONTROLLER_NORMAL = new AlarmEnum("\u63a7\u5236\u5668\u6b63\u5e38", new int[]{9}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new VersionParser(ins);
            }
        };
        CONTROLLER_BREAK = new AlarmEnum("\u63a7\u5236\u5668\u6545\u969c", new int[]{239}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new VersionParser(ins);
            }
        };
        CONTROLLER_RESET = new AlarmEnum("\u63a7\u5236\u5668\u590d\u4f4d", new int[]{1}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new VersionParser(ins);
            }
        };
        CONTROLLER_MUFFLING = new AlarmEnum("\u63a7\u5236\u5668\u6d88\u97f3", new int[]{11}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new VersionParser(ins);
            }
        };
        FIRE_ALARM = new AlarmEnum("\u706b\u8b66", new int[]{128, 10}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        FAULT = new AlarmEnum("\u6545\u969c", new int[]{129}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        FAIL_BACK = new AlarmEnum("\u6545\u969c\u6062\u590d", new int[]{130}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        CIRCUIT_FAILURE = new AlarmEnum("\u56de\u8def\u6545\u969c", new int[]{135}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        LOOP_FAILURE_RECOVERY = new AlarmEnum("\u56de\u8def\u6545\u969c\u6062\u590d", new int[]{136}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        START_AUTOMATICALLY = new AlarmEnum("\u81ea\u52a8\u542f\u52a8", new int[]{131}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        AUTOMATIC_STOP = new AlarmEnum("\u81ea\u52a8\u505c\u6b62", new int[]{132}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        START_MANUALLY = new AlarmEnum("\u624b\u52a8\u542f\u52a8", new int[]{144}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        STOP_MANUALLY = new AlarmEnum("\u624b\u52a8\u505c\u6b62", new int[]{145}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        THE_DEVICE_ANSWERS = new AlarmEnum("\u8bbe\u5907\u56de\u7b54", new int[]{133}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        ANSWER_REVOCATION = new AlarmEnum("\u56de\u7b54\u64a4\u9500", new int[]{134}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        PART_ISOLATION = new AlarmEnum("\u90e8\u4ef6\u9694\u79bb", new int[]{152}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        PART_ISOLATION_IS_REVOKED = new AlarmEnum("\u90e8\u4ef6\u9694\u79bb\u64a4\u9500", new int[]{151}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        MULTI_LINE_MANUAL_START = new AlarmEnum("\u591a\u7ebf\u624b\u52a8\u542f\u52a8", 242, "-1,8", new int[]{81}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MultiLineAlarmParser(ins);
            }
        };
        multi_line_manual_stop = new AlarmEnum("\u591a\u7ebf\u624b\u52a8\u505c\u6b62", 242, "-1,8", new int[]{82}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MultiLineAlarmParser(ins);
            }
        };
        MULTI_LINE_ANSWER = new AlarmEnum("\u591a\u7ebf\u56de\u7b54", 242, "-1,8", new int[]{83}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MultiLineAlarmParser(ins);
            }
        };
        MULTI_LINE_STOP_ANSWERING = new AlarmEnum("\u591a\u7ebf\u505c\u6b62\u56de\u7b54", 242, "-1,8", new int[]{84}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MultiLineAlarmParser(ins);
            }
        };
        MULTI_LINE_AUTO_START = new AlarmEnum("\u591a\u7ebf\u81ea\u52a8\u542f\u52a8", 242, "-1,8", new int[]{85}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MultiLineAlarmParser(ins);
            }
        };
        MULTI_LINE_AUTOMATIC_STOP = new AlarmEnum("\u591a\u7ebf\u81ea\u52a8\u505c\u6b62", 242, "-1,8", new int[]{86}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MultiLineAlarmParser(ins);
            }
        };
        MULTI_LINE_AUTO_START_DELAY = new AlarmEnum("\u591a\u7ebf\u81ea\u52a8\u542f\u52a8\u5ef6\u65f6", 242, "-1,8", new int[]{87}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MultiLineAlarmParser(ins);
            }
        };
        MULTI_LINE_RESPONSE_IS_MISSING = new AlarmEnum("\u591a\u7ebf\u5e94\u7b54\u7f3a\u5931", 242, "-1,8", new int[]{88}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MultiLineAlarmParser(ins);
            }
        };
        MULTI_LINE_LINE_FAILURE = new AlarmEnum("\u591a\u7ebf\u7ebf\u8def\u6545\u969c", 242, "-1,8", new int[]{89}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MultiLineAlarmParser(ins);
            }
        };
        MULTI_LINE_LINE_FAILURE_RECOVERY = new AlarmEnum("\u591a\u7ebf\u7ebf\u8def\u6545\u969c\u6062\u590d", 242, "-1,8", new int[]{90}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MultiLineAlarmParser(ins);
            }
        };
        ANALOG_ALARM = new AlarmEnum("\u6a21\u62df\u62a5\u8b66", -1, new int[]{139}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new SimulationAlarmParser(ins);
            }
        };
        REGULATORY_ALARMS = new AlarmEnum("\u76d1\u7ba1\u62a5\u8b66", new int[]{140}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        REGULATORY_ALARM_REVOCATION = new AlarmEnum("\u76d1\u7ba1\u62a5\u8b66\u64a4\u9500", new int[]{141}){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonAlarmParser(ins);
            }
        };
        $VALUES = new AlarmEnum[]{CONTROLLER_HEART, CONTROLLER_NORMAL, CONTROLLER_BREAK, CONTROLLER_RESET, CONTROLLER_MUFFLING, FIRE_ALARM, FAULT, FAIL_BACK, CIRCUIT_FAILURE, LOOP_FAILURE_RECOVERY, START_AUTOMATICALLY, AUTOMATIC_STOP, START_MANUALLY, STOP_MANUALLY, THE_DEVICE_ANSWERS, ANSWER_REVOCATION, PART_ISOLATION, PART_ISOLATION_IS_REVOKED, MULTI_LINE_MANUAL_START, multi_line_manual_stop, MULTI_LINE_ANSWER, MULTI_LINE_STOP_ANSWERING, MULTI_LINE_AUTO_START, MULTI_LINE_AUTOMATIC_STOP, MULTI_LINE_AUTO_START_DELAY, MULTI_LINE_RESPONSE_IS_MISSING, MULTI_LINE_LINE_FAILURE, MULTI_LINE_LINE_FAILURE_RECOVERY, ANALOG_ALARM, REGULATORY_ALARMS, REGULATORY_ALARM_REVOCATION};
        ALARM_MAP = new HashMap<Integer, AlarmEnum>();
        for (AlarmEnum alarm : alarmEnums = AlarmEnum.values()) {
            for (int i : alarm.code) {
                ALARM_MAP.put(i, alarm);
            }
        }
    }
}

