/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.JBF293K.enums;

import cn.allbs.utils.JBF293K.format.data.AbstractParser;
import cn.allbs.utils.JBF293K.format.data.BoardSprayParser;
import cn.allbs.utils.JBF293K.format.data.CommonSprayParser;
import cn.allbs.utils.JBF293K.format.data.MessageSprayParser;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class SprayEnum
extends Enum<SprayEnum> {
    public static final /* enum */ SprayEnum GAS_LINE_FAILURE;
    public static final /* enum */ SprayEnum GAS_LINE_FAILURE_RECOVERY;
    public static final /* enum */ SprayEnum GAS_SPRAY_RESPONSE;
    public static final /* enum */ SprayEnum GAS_SPRAYING_RESPONSE_WITHDRAWS;
    public static final /* enum */ SprayEnum SOUND_AND_LIGHT_START;
    public static final /* enum */ SprayEnum SOUND_AND_LIGHT_STOP;
    public static final /* enum */ SprayEnum RELATED_DEVICE_ACTIONS;
    public static final /* enum */ SprayEnum THE_RELATED_DEVICE_ACTION_STOPS;
    public static final /* enum */ SprayEnum FIRE_ZONE_ACTIVATION;
    public static final /* enum */ SprayEnum THE_FIRE_ZONE_STOPS;
    public static final /* enum */ SprayEnum SPRAY_START;
    public static final /* enum */ SprayEnum DELAYED_START;
    public static final /* enum */ SprayEnum REMOTE_STOP_ACTION_UNDO;
    public static final /* enum */ SprayEnum BOARD_FAILURE;
    public static final /* enum */ SprayEnum BOARD_FAILURE_RECOVERY;
    public static final /* enum */ SprayEnum MAIN_POWER_FAILURE;
    public static final /* enum */ SprayEnum MAIN_POWER_FAILURE_RECOVERY;
    public static final /* enum */ SprayEnum POWER_BACKUP_FAILURE;
    public static final /* enum */ SprayEnum STANDBY_FAULT_RECOVERY;
    public static final Table<Integer, Short, SprayEnum> SPRAY_ENUM_TABLE;
    public static final Map<Integer, SprayEnum> SPRAY_ENUM_MAP;
    private final String orderName;
    private final int code;
    private final Integer control;
    private final short messageType;
    private final String part;
    private static final /* synthetic */ SprayEnum[] $VALUES;

    public static SprayEnum[] values() {
        return (SprayEnum[])$VALUES.clone();
    }

    public static SprayEnum valueOf(String name) {
        return Enum.valueOf(SprayEnum.class, name);
    }

    public abstract AbstractParser execute(InputStream var1);

    private SprayEnum(String orderName, int code, short messageType, String part) {
        this.orderName = orderName;
        this.code = code;
        this.control = null;
        this.messageType = messageType;
        this.part = part;
    }

    private SprayEnum(String orderName, int code, short messageType) {
        this.orderName = orderName;
        this.code = code;
        this.control = null;
        this.messageType = messageType;
        this.part = null;
    }

    public String getOrderName() {
        return this.orderName;
    }

    public int getCode() {
        return this.code;
    }

    public Integer getControl() {
        return this.control;
    }

    public short getMessageType() {
        return this.messageType;
    }

    public String getPart() {
        return this.part;
    }

    static {
        SprayEnum[] sprayEnums;
        GAS_LINE_FAILURE = new SprayEnum("\u6c14\u4f53\u7ebf\u8def\u6545\u969c", 250, 1, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        GAS_LINE_FAILURE_RECOVERY = new SprayEnum("\u6c14\u4f53\u7ebf\u8def\u6545\u969c\u6062\u590d", 250, 2, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        GAS_SPRAY_RESPONSE = new SprayEnum("\u6c14\u4f53\u55b7\u6d12\u5e94\u7b54", 250, 3, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        GAS_SPRAYING_RESPONSE_WITHDRAWS = new SprayEnum("\u6c14\u4f53\u55b7\u6d12\u5e94\u7b54\u64a4\u9500", 250, 4, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        SOUND_AND_LIGHT_START = new SprayEnum("\u58f0\u5149\u542f\u52a8", 250, 5, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        SOUND_AND_LIGHT_STOP = new SprayEnum("\u58f0\u5149\u505c\u6b62", 250, 6, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        RELATED_DEVICE_ACTIONS = new SprayEnum("\u76f8\u5173\u8bbe\u5907\u52a8\u4f5c", 250, 7, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        THE_RELATED_DEVICE_ACTION_STOPS = new SprayEnum("\u76f8\u5173\u8bbe\u5907\u52a8\u4f5c\u505c\u6b62", 250, 8, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        FIRE_ZONE_ACTIVATION = new SprayEnum("\u9632\u706b\u533a\u542f\u52a8", 250, 9, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        THE_FIRE_ZONE_STOPS = new SprayEnum("\u9632\u706b\u533a\u505c\u6b62", 250, 10, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        SPRAY_START = new SprayEnum("\u55b7\u6d12\u542f\u52a8", 250, 11, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        DELAYED_START = new SprayEnum("\u5ef6\u65f6\u542f\u52a8", 250, 12, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        REMOTE_STOP_ACTION_UNDO = new SprayEnum("\u8fdc\u7a0b\u505c\u6b62\u52a8\u4f5c\u64a4\u9500", 250, 14, "-1,4"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new MessageSprayParser(ins);
            }
        };
        BOARD_FAILURE = new SprayEnum("\u677f\u6545\u969c", 112, 128, "\u677f\u53f7"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new BoardSprayParser(ins);
            }
        };
        BOARD_FAILURE_RECOVERY = new SprayEnum("\u677f\u6545\u969c\u6062\u590d", 112, 144, "\u677f\u53f7"){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new BoardSprayParser(ins);
            }
        };
        MAIN_POWER_FAILURE = new SprayEnum("\u4e3b\u7535\u6545\u969c", 113, 128){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonSprayParser(ins);
            }
        };
        MAIN_POWER_FAILURE_RECOVERY = new SprayEnum("\u4e3b\u7535\u6545\u969c\u6062\u590d", 113, 144){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonSprayParser(ins);
            }
        };
        POWER_BACKUP_FAILURE = new SprayEnum("\u5907\u7535\u6545\u969c", 114, 128){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonSprayParser(ins);
            }
        };
        STANDBY_FAULT_RECOVERY = new SprayEnum("\u5907\u7535\u6545\u969c\u6062\u590d", 114, 144){

            @Override
            public AbstractParser execute(InputStream ins) {
                return new CommonSprayParser(ins);
            }
        };
        $VALUES = new SprayEnum[]{GAS_LINE_FAILURE, GAS_LINE_FAILURE_RECOVERY, GAS_SPRAY_RESPONSE, GAS_SPRAYING_RESPONSE_WITHDRAWS, SOUND_AND_LIGHT_START, SOUND_AND_LIGHT_STOP, RELATED_DEVICE_ACTIONS, THE_RELATED_DEVICE_ACTION_STOPS, FIRE_ZONE_ACTIVATION, THE_FIRE_ZONE_STOPS, SPRAY_START, DELAYED_START, REMOTE_STOP_ACTION_UNDO, BOARD_FAILURE, BOARD_FAILURE_RECOVERY, MAIN_POWER_FAILURE, MAIN_POWER_FAILURE_RECOVERY, POWER_BACKUP_FAILURE, STANDBY_FAULT_RECOVERY};
        SPRAY_ENUM_TABLE = HashBasedTable.create();
        SPRAY_ENUM_MAP = new HashMap<Integer, SprayEnum>(4);
        for (SprayEnum sprayEnum : sprayEnums = SprayEnum.values()) {
            SPRAY_ENUM_TABLE.put((Object)sprayEnum.code, (Object)sprayEnum.messageType, (Object)sprayEnum);
            if (SPRAY_ENUM_MAP.containsKey(sprayEnum.code)) continue;
            SPRAY_ENUM_MAP.put(sprayEnum.code, sprayEnum);
        }
    }
}

