/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.JBF293K.format;

import cn.allbs.core.Configurator;
import cn.allbs.core.Configured;
import cn.allbs.exception.JBF293KException;
import cn.allbs.feature.VerifyFeature;
import cn.allbs.utils.AsciiUtil;
import cn.allbs.utils.Crc8MAXIM;
import cn.allbs.utils.JBF293K.enums.AlarmEnum;
import cn.allbs.utils.JBF293K.enums.FireAndEleEnum;
import cn.allbs.utils.JBF293K.enums.KeyWordEnums;
import cn.allbs.utils.JBF293K.enums.PacketElement;
import cn.allbs.utils.JBF293K.enums.SprayEnum;
import cn.allbs.utils.JBF293K.format.data.AbstractParser;
import cn.allbs.utils.JBF293K.utils.VerifyUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JBF293KParser
implements Configured<JBF293KParser>,
Closeable {
    public static int HEADER = 130;
    public static int FOOTER = 131;
    protected DataInputStream dataOutputStream;
    protected byte[] msgBytes;
    private int count;
    private int verifyFeature;

    public JBF293KParser(byte[] msgBytes) {
        this.msgBytes = msgBytes;
        ByteArrayInputStream bao = new ByteArrayInputStream(msgBytes);
        this.dataOutputStream = new DataInputStream(bao);
    }

    public JBF293KParser(InputStream in) {
        this.dataOutputStream = new DataInputStream(in);
    }

    public byte[] readHeader() throws JBF293KException, IOException {
        byte[] header = new byte[PacketElement.START.getLen()];
        this.count = header.length;
        for (int i = 0; i < this.count; ++i) {
            header[i] = this.dataOutputStream.readByte();
        }
        VerifyUtil.verifyLen(this.count, 1, PacketElement.START);
        VerifyUtil.verifyByte(header, HEADER, PacketElement.START);
        return header;
    }

    public short readOrderType() throws JBF293KException, IOException {
        byte[] order = new byte[KeyWordEnums.ORDER.getLen().intValue()];
        this.count = order.length;
        for (int i = 0; i < this.count; ++i) {
            order[i] = this.dataOutputStream.readByte();
        }
        return AsciiUtil.bytesToShort(order, 48);
    }

    public AbstractParser readData(int orderType) throws JBF293KException, IOException {
        AbstractParser abstractParser = null;
        if (AlarmEnum.ALARM_MAP.containsKey(orderType)) {
            abstractParser = AlarmEnum.ALARM_MAP.get(orderType).execute(this.dataOutputStream);
            abstractParser.parseMap().put(KeyWordEnums.ORDER.getName(), AlarmEnum.ALARM_MAP.get(orderType).getDesc());
        }
        if (SprayEnum.SPRAY_ENUM_MAP.containsKey(orderType)) {
            abstractParser = SprayEnum.SPRAY_ENUM_MAP.get(orderType).execute(this.dataOutputStream);
            abstractParser.parseMap().put(KeyWordEnums.ORDER.getName(), SprayEnum.SPRAY_ENUM_MAP.get(orderType).getOrderName());
        }
        if (FireAndEleEnum.FIRE_AND_ELE_ENUM_MAP.containsKey(orderType)) {
            abstractParser = FireAndEleEnum.FIRE_AND_ELE_ENUM_MAP.get(orderType).execute(this.dataOutputStream);
            abstractParser.parseMap().put(KeyWordEnums.ORDER.getName(), FireAndEleEnum.FIRE_AND_ELE_ENUM_MAP.get(orderType).getOrderName());
        }
        if (abstractParser == null) {
            throw new JBF293KException("\u672a\u5b9a\u4e49\u7684\u547d\u4ee4\u7c7b\u578b!");
        }
        abstractParser.parseMap().put(KeyWordEnums.ORDER.getPreName(), orderType);
        abstractParser.addSummation(orderType);
        abstractParser.create();
        return abstractParser;
    }

    public void readCheck(short summation) throws IOException, JBF293KException {
        byte[] crc = new byte[KeyWordEnums.ACCUMULATE_SUM.getLen().intValue()];
        this.count = crc.length;
        for (int i = 0; i < this.count; ++i) {
            crc[i] = this.dataOutputStream.readByte();
        }
        short crcNum = AsciiUtil.bytesToShort(crc, 48);
        if (VerifyFeature.SUMMATION.enabledIn(this.verifyFeature)) {
            VerifyUtil.verifyCheck(summation != crcNum);
        }
    }

    public void readCheckCrc(int ... bytes) throws IOException, JBF293KException {
        byte[] crc = new byte[KeyWordEnums.CRC.getLen().intValue()];
        this.count = crc.length;
        for (int i = 0; i < this.count; ++i) {
            crc[i] = this.dataOutputStream.readByte();
        }
        short crcNum = AsciiUtil.bytesToShort(crc, 48);
        Crc8MAXIM checkCrc = Crc8MAXIM.getInstance();
        short checkCrcNum = (short)checkCrc.compute(bytes);
        if (VerifyFeature.DATA_CRC.enabledIn(this.verifyFeature)) {
            VerifyUtil.verifyCheck(crcNum != checkCrcNum);
        }
    }

    public byte[] readFooter() throws JBF293KException, IOException {
        byte[] footer = new byte[PacketElement.END.getLen()];
        this.count = footer.length;
        for (int i = 0; i < this.count; ++i) {
            footer[i] = this.dataOutputStream.readByte();
        }
        VerifyUtil.verifyLen(this.count, 1, PacketElement.END);
        VerifyUtil.verifyByte(footer, FOOTER, PacketElement.END);
        return footer;
    }

    @Override
    public void configured(Configurator<JBF293KParser> by) {
        by.config(this);
    }

    @Override
    public void close() throws IOException {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

