/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.JBF293K.format.data;

import cn.allbs.core.Configurator;
import cn.allbs.core.Configured;
import cn.allbs.exception.JBF293KException;
import cn.allbs.utils.AsciiUtil;
import cn.allbs.utils.JBF293K.enums.KeyWordEnums;
import cn.allbs.utils.JBF293K.enums.PacketElement;
import cn.allbs.utils.JBF293K.format.data.IParser;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractParser
implements IParser,
Configured<AbstractParser>,
Closeable {
    protected DataInputStream dataOutputStream;
    protected int readLen = 20;
    protected int summation = 0;
    protected List<Short> crcBList = new LinkedList<Short>();
    protected boolean hasData = false;
    protected final Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>(19);

    public AbstractParser(byte[] bytes) {
        ByteArrayInputStream bao = new ByteArrayInputStream(bytes);
        this.dataOutputStream = new DataInputStream(bao);
    }

    public AbstractParser(InputStream in) {
        this.dataOutputStream = new DataInputStream(in);
    }

    public AbstractParser(int readLen) {
        this.readLen = readLen;
    }

    public AbstractParser(InputStream in, int readLen) {
        this.readLen = readLen;
        this.dataOutputStream = new DataInputStream(in);
    }

    @Override
    public void create() throws IOException, JBF293KException {
        this.readCode();
        this.readVersion();
        this.readMachineNo();
        this.readLoop();
        this.readInfoType();
        this.readPart();
        this.readPartType();
        this.readNullInfo();
        this.readTime();
        this.readSummation();
        this.readAlarmData();
        this.dataMap.put(KeyWordEnums.ACCUMULATE_SUM.getName(), this.getSummation());
        this.close();
    }

    protected void readCode() throws IOException {
    }

    protected void readMachineNo() throws IOException {
    }

    protected void readLoop() throws IOException {
    }

    protected void readInfoType() throws IOException {
    }

    protected void readPart() throws IOException, JBF293KException {
    }

    protected void readPartType() throws IOException, JBF293KException {
    }

    protected void readVersion() throws IOException {
    }

    protected void readCrc() throws IOException {
    }

    protected void readTime() throws IOException {
        short year = this.handleByte(PacketElement.D6.getLen());
        short month = this.handleByte(PacketElement.D7.getLen());
        short day = this.handleByte(PacketElement.D8.getLen());
        short hour = this.handleByte(PacketElement.D9.getLen());
        short minute = this.handleByte(PacketElement.D10.getLen());
        short second = this.handleByte(PacketElement.D11.getLen());
        this.dataMap.put(KeyWordEnums.TIME.getName(), LocalDateTime.of(2000 + year, month, (int)day, (int)hour, (int)minute, (int)second).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
    }

    protected void readSummation() throws IOException, JBF293KException {
    }

    protected void readNullInfo() throws IOException {
    }

    protected void readAlarmData() throws IOException, JBF293KException {
    }

    @Override
    public void configured(Configurator<AbstractParser> by) {
        by.config(this);
    }

    @Override
    public void close() throws IOException {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> parseMap() {
        return this.dataMap;
    }

    @Override
    public int currentReadLen() {
        return this.readLen;
    }

    public void addSummation(int num) {
        this.crcBList.add((short)(num & 0xFF));
        this.summation += num;
    }

    public short getSummation() {
        return (short)(this.summation & 0xFF);
    }

    public int[] getCrcNum() {
        int len = this.crcBList.size();
        int[] bytes = new int[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.crcBList.get(i).shortValue();
        }
        return bytes;
    }

    public short handleByte(int len) throws IOException {
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = this.dataOutputStream.readByte();
        }
        short castNum = AsciiUtil.bytesToShort(b, 48);
        this.addSummation(castNum);
        return castNum;
    }

    public boolean isHasData() {
        return this.hasData;
    }

    public void setHasData(boolean hasData) {
        this.hasData = hasData;
    }
}

