/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.JBF293K.format.data;

import cn.allbs.exception.JBF293KException;
import cn.allbs.utils.AsciiUtil;
import cn.allbs.utils.JBF293K.enums.EleFireStatusEnum;
import cn.allbs.utils.JBF293K.enums.EleFireTypeEnum;
import cn.allbs.utils.JBF293K.enums.KeyWordEnums;
import cn.allbs.utils.JBF293K.enums.PacketElement;
import cn.allbs.utils.JBF293K.format.data.AbstractParser;
import cn.allbs.utils.JBF293K.utils.VerifyUtil;
import java.io.IOException;
import java.io.InputStream;

public class EleFireParser
extends AbstractParser {
    public EleFireParser(InputStream in) {
        super(in);
    }

    @Override
    protected void readMachineNo() throws IOException {
        short machineNo = this.handleByte(PacketElement.D2.getLen());
        this.dataMap.put(KeyWordEnums.MACHINE_NO.getName(), machineNo);
    }

    @Override
    protected void readLoop() throws IOException {
        short loop = this.handleByte(PacketElement.D3.getLen());
        this.dataMap.put(KeyWordEnums.CIRCUIT.getName(), loop);
    }

    @Override
    protected void readPart() throws IOException, JBF293KException {
        short address = this.handleByte(PacketElement.D4.getLen());
        this.dataMap.put(KeyWordEnums.ADDRESS.getName(), address);
    }

    @Override
    protected void readPartType() throws IOException, JBF293KException {
        short partType = this.handleByte(PacketElement.D5.getLen());
        boolean bl = this.hasData = partType == 255;
        if (!this.hasData) {
            short type = (short)AsciiUtil.getLow4FromShort(partType);
            short status = (short)AsciiUtil.getHeight4FromShort(partType);
            try {
                this.dataMap.put(KeyWordEnums.TYPE.getName(), EleFireTypeEnum.ELE_FIRE_TYPE_MAP.get(type).getDesc());
                this.dataMap.put(KeyWordEnums.STATUS.getName(), EleFireStatusEnum.ELE_FIRE_STATUS_MAP.get(status));
            }
            catch (Exception e) {
                throw new JBF293KException("\u65e0\u6cd5\u786e\u5b9a\u7684\u90e8\u4ef6\u72b6\u6001!");
            }
            this.dataMap.put(KeyWordEnums.TYPE.getPreName(), type);
            this.dataMap.put(KeyWordEnums.STATUS.getPreName(), status);
        }
    }

    @Override
    protected void readSummation() throws IOException, JBF293KException {
        if (!this.hasData) {
            return;
        }
        byte[] crc = new byte[KeyWordEnums.ACCUMULATE_SUM.getLen().intValue()];
        for (int i = 0; i < KeyWordEnums.ACCUMULATE_SUM.getLen(); ++i) {
            crc[i] = this.dataOutputStream.readByte();
        }
        short crcNum = AsciiUtil.bytesToShort(crc, 48);
        VerifyUtil.verifyCheck(this.getSummation() != crcNum);
        this.addSummation(crcNum);
    }

    @Override
    protected void readAlarmData() throws IOException, JBF293KException {
        if (!this.hasData) {
            return;
        }
        short partType = this.handleByte(PacketElement.D13.getLen());
        short type = (short)AsciiUtil.getLow4FromShort(partType);
        short status = (short)AsciiUtil.getHeight4FromShort(partType);
        try {
            EleFireTypeEnum ele = EleFireTypeEnum.ELE_FIRE_TYPE_MAP.get(type);
            this.dataMap.put(KeyWordEnums.TYPE.getName(), ele.getDesc());
            this.dataMap.put(KeyWordEnums.STATUS.getName(), EleFireStatusEnum.ELE_FIRE_STATUS_MAP.get(status));
            this.dataMap.put(KeyWordEnums.TYPE.getPreName(), type);
            this.dataMap.put(KeyWordEnums.STATUS.getPreName(), status);
            short controller = this.handleByte(PacketElement.D14.getLen());
            this.dataMap.put(KeyWordEnums.CONTROLLER.getName(), controller);
            short low = this.handleByte(PacketElement.D15.getLen());
            short high = this.handleByte(PacketElement.D16.getLen());
            double value = (double)(low & 0xFF | (high & 0xFF) << 8) / Math.pow(10.0, ele.getFactor().intValue());
            if (high >= 128 && ele.getMinus().booleanValue()) {
                value = 0.0 - value;
            }
            this.dataMap.put(KeyWordEnums.ALARM_VALUE.getName(), value);
            this.dataMap.put(KeyWordEnums.UNIT.getName(), ele.getUnit());
        }
        catch (Exception e) {
            throw new JBF293KException("\u65e0\u6cd5\u786e\u5b9a\u7684\u90e8\u4ef6\u72b6\u6001!");
        }
    }
}

