/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.JBF293K.format.data;

import cn.allbs.exception.JBF293KException;
import cn.allbs.utils.AsciiUtil;
import cn.allbs.utils.JBF293K.enums.FireDoorsStatusEnum;
import cn.allbs.utils.JBF293K.enums.FireDoorsTypeEnum;
import cn.allbs.utils.JBF293K.enums.KeyWordEnums;
import cn.allbs.utils.JBF293K.enums.PacketElement;
import cn.allbs.utils.JBF293K.format.data.AbstractParser;
import java.io.IOException;
import java.io.InputStream;

public class FireDoorParser
extends AbstractParser {
    public FireDoorParser(InputStream in) {
        super(in);
    }

    @Override
    protected void readMachineNo() throws IOException {
        short machineNo = this.handleByte(KeyWordEnums.MACHINE_NO.getLen());
        this.dataMap.put(KeyWordEnums.MACHINE_NO.getName(), machineNo);
    }

    @Override
    protected void readLoop() throws IOException {
        short loop = this.handleByte(KeyWordEnums.CIRCUIT.getLen());
        this.dataMap.put(KeyWordEnums.CIRCUIT.getName(), loop);
    }

    @Override
    protected void readPart() throws IOException, JBF293KException {
        short address = this.handleByte(KeyWordEnums.ADDRESS.getLen());
        this.dataMap.put(KeyWordEnums.ADDRESS.getName(), address);
    }

    @Override
    protected void readPartType() throws IOException, JBF293KException {
        short partType = this.handleByte(PacketElement.D5.getLen());
        short type = (short)AsciiUtil.getLow4FromShort(partType);
        short status = (short)AsciiUtil.getHeight4FromShort(partType);
        try {
            this.dataMap.put(KeyWordEnums.TYPE.getName(), FireDoorsTypeEnum.DOOR_TYPE.get(type));
            this.dataMap.put(KeyWordEnums.STATUS.getName(), FireDoorsStatusEnum.DOOR_STATUS.get(status));
        }
        catch (Exception e) {
            throw new JBF293KException("\u65e0\u6cd5\u786e\u5b9a\u7684\u90e8\u4ef6\u72b6\u6001!");
        }
        this.dataMap.put(KeyWordEnums.TYPE.getPreName(), type);
        this.dataMap.put(KeyWordEnums.STATUS.getPreName(), status);
    }
}

