/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.JBF293K.format.data;

import cn.allbs.exception.JBF293KException;
import cn.allbs.utils.JBF293K.enums.KeyWordEnums;
import cn.allbs.utils.JBF293K.enums.PacketElement;
import cn.allbs.utils.JBF293K.enums.SprayEnum;
import cn.allbs.utils.JBF293K.format.data.AbstractParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class MessageSprayParser
extends AbstractParser {
    public MessageSprayParser(InputStream in) {
        super(in);
    }

    @Override
    protected void readMachineNo() throws IOException {
        short machineNo = this.handleByte(KeyWordEnums.MACHINE_NO.getLen());
        this.dataMap.put(KeyWordEnums.MACHINE_NO.getName(), machineNo);
    }

    @Override
    protected void readInfoType() throws IOException {
        short messageInfo = this.handleByte(KeyWordEnums.MESSAGE_INFO.getLen());
        this.dataMap.put(KeyWordEnums.MESSAGE_INFO.getPreName(), messageInfo);
        this.dataMap.put(KeyWordEnums.MESSAGE_INFO.getName(), ((SprayEnum)((Object)Objects.requireNonNull(SprayEnum.SPRAY_ENUM_TABLE.get((Object)SprayEnum.GAS_LINE_FAILURE.getCode(), (Object)messageInfo)))).getOrderName());
    }

    @Override
    protected void readPart() throws IOException, JBF293KException {
        short part = this.handleByte(PacketElement.D4.getLen());
        short[] s = this.countDiskAndDistrict(part);
        this.dataMap.put(KeyWordEnums.DISK.getName(), s[0]);
        this.dataMap.put(KeyWordEnums.DISTRICT.getName(), s[1]);
        this.dataMap.put(KeyWordEnums.PART.getName(), part);
    }

    private short[] countDiskAndDistrict(short total) throws JBF293KException {
        for (short i = 1; i < 64; i = (short)((short)(i + 1))) {
            for (short j = 1; j < 5; j = (short)((short)(j + 1))) {
                if ((i - 1) * 4 + j != total) continue;
                return new short[]{i, j};
            }
        }
        throw new JBF293KException("\u65e0\u6cd5\u8ba1\u7b97\u7684\u76d8\u53f7\u548c\u4e13\u7ebf\u53f7!");
    }

    @Override
    protected void readNullInfo() throws IOException {
        this.handleByte(PacketElement.D5.getLen());
    }
}

