/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.SFJK200.enums;

import cn.allbs.utils.SFJK200.format.data.AbstractParser;
import cn.allbs.utils.SFJK200.format.data.AttributeUnitParser;
import cn.allbs.utils.SFJK200.format.data.ControlStatusParser;
import cn.allbs.utils.SFJK200.format.data.DetectorParser;
import cn.allbs.utils.SFJK200.format.data.EcpsStatusParser;
import cn.allbs.utils.SFJK200.format.data.LowAlarmParser;
import cn.allbs.utils.SFJK200.format.data.PlacementParser;
import cn.allbs.utils.SFJK200.format.data.ProbeStatusParser;

public enum OrderEnum {
    NUMBER_OF_PLACEMENT_1_2("\u8bfb 1\u30012 \u56de\u8def\u914d\u7f6e\u70b9\u6570", 0, 1, new PlacementParser()),
    NUMBER_OF_PLACEMENT_3_4("\u8bfb 3\u30014 \u56de\u8def\u914d\u7f6e\u70b9\u6570", 1, 1, new PlacementParser()),
    ATTRIBUTE_UNITS_1("1 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u5c5e\u6027\u5355\u4f4d", 2, 249, 1, 100, new AttributeUnitParser()),
    ATTRIBUTE_UNITS_2("2 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u5c5e\u6027\u5355\u4f4d", 250, 497, 1, 100, new AttributeUnitParser()),
    ATTRIBUTE_UNITS_3("3 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u5c5e\u6027\u5355\u4f4d", 498, -745, 1, 100, new AttributeUnitParser()),
    ATTRIBUTE_UNITS_4("4 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u5c5e\u6027\u5355\u4f4d", 746, 993, 1, 100, new AttributeUnitParser()),
    LOW_ALARM_VALUE_1("1 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u4f4e\u9650\u62a5\u8b66\u503c", 994, 1241, 1, 100, new LowAlarmParser()),
    LOW_ALARM_VALUE_2("2 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u4f4e\u9650\u62a5\u8b66\u503c", 1242, 1489, 1, 100, new LowAlarmParser()),
    LOW_ALARM_VALUE_3("3 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u4f4e\u9650\u62a5\u8b66\u503c", 1490, 1737, 1, 100, new LowAlarmParser()),
    LOW_ALARM_VALUE_4("4 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u4f4e\u9650\u62a5\u8b66\u503c", 1738, 1985, 1, 100, new LowAlarmParser()),
    PROBE_STATUS_1("1 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u63a2\u6d4b\u5668\u72b6\u6001", 1986, 2233, 1, 100, new ProbeStatusParser()),
    PROBE_STATUS_2("2 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u63a2\u6d4b\u5668\u72b6\u6001", 2234, 2481, 1, 100, new ProbeStatusParser()),
    PROBE_STATUS_3("3 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u63a2\u6d4b\u5668\u72b6\u6001", 2482, 2729, 1, 100, new ProbeStatusParser()),
    PROBE_STATUS_4("4 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u63a2\u6d4b\u5668\u72b6\u6001", 2730, 2977, 1, 100, new ProbeStatusParser()),
    DETECTOR_CONCENTRATION_1("1 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u63a2\u6d4b\u5668\u6d53\u5ea6", 2978, 3225, 1, 100, new DetectorParser()),
    DETECTOR_CONCENTRATION_2("2 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u63a2\u6d4b\u5668\u6d53\u5ea6", 3226, 3473, 1, 100, new DetectorParser()),
    DETECTOR_CONCENTRATION_3("3 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u63a2\u6d4b\u5668\u6d53\u5ea6", 3474, 3721, 1, 100, new DetectorParser()),
    DETECTOR_CONCENTRATION_4("4 \u56de\u8def 1-248 \u70b9\u4f4d\u7684\u63a2\u6d4b\u5668\u6d53\u5ea6", 3722, 3969, 1, 100, new DetectorParser()),
    ECPS_STATUS_1("1 \u56de\u8def\u5916\u63a7\u7535\u6e90\u72b6\u6001", 3970, 3971, 2, new EcpsStatusParser()),
    ECPS_STATUS_2("2 \u56de\u8def\u5916\u63a7\u7535\u6e90\u72b6\u6001", 3972, 3973, 2, new EcpsStatusParser()),
    ECPS_STATUS_3("3 \u56de\u8def\u5916\u63a7\u7535\u6e90\u72b6\u6001", 3974, 3975, 2, new EcpsStatusParser()),
    ECPS_STATUS_4("4 \u56de\u8def\u5916\u63a7\u7535\u6e90\u72b6\u6001", 3976, 3977, 2, new EcpsStatusParser()),
    CONTROL_STATUS("\u63a7\u5236\u72b6\u6001", 3978, 1, new ControlStatusParser());

    private final String desc;
    private final int startAddress;
    private final Integer endAdress;
    private final int startRegister;
    private final Integer endRegister;
    private final AbstractParser abstractParser;

    private OrderEnum(String desc, int startAddress, int startRegister, AbstractParser abstractParser) {
        this.desc = desc;
        this.startAddress = startAddress;
        this.endAdress = null;
        this.startRegister = startRegister;
        this.endRegister = null;
        this.abstractParser = abstractParser;
    }

    private OrderEnum(String desc, int startAddress, Integer endAddress, int startRegister, AbstractParser abstractParser) {
        this.desc = desc;
        this.startAddress = startAddress;
        this.endAdress = endAddress;
        this.startRegister = startRegister;
        this.endRegister = null;
        this.abstractParser = abstractParser;
    }

    private OrderEnum(String desc, int startAddress, Integer endAddress, int startRegister, int endRegister, AbstractParser abstractParser) {
        this.desc = desc;
        this.startAddress = startAddress;
        this.endAdress = endAddress;
        this.startRegister = startRegister;
        this.endRegister = endRegister;
        this.abstractParser = abstractParser;
    }

    public static OrderEnum orderInfo(int register) {
        OrderEnum[] orderEnums;
        for (OrderEnum order : orderEnums = OrderEnum.values()) {
            if (order.getStartAddress() != register && (order.getEndAdress() == null || order.getStartAddress() > register || order.getEndAdress() < register)) continue;
            return order;
        }
        return null;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public Integer getEndAdress() {
        return this.endAdress;
    }

    public int getStartRegister() {
        return this.startRegister;
    }

    public Integer getEndRegister() {
        return this.endRegister;
    }

    public AbstractParser getAbstractParser() {
        return this.abstractParser;
    }
}

