/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.SFJK200.format;

import cn.allbs.core.Configurator;
import cn.allbs.core.Configured;
import cn.allbs.utils.AsciiUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;

public class SFJK200Generator
implements Configured<SFJK200Generator>,
Closeable {
    protected ByteArrayOutputStream bao;
    protected byte[] dataByte = new byte[6];

    public SFJK200Generator(ByteArrayOutputStream bao) {
        this.bao = bao;
    }

    @Override
    public void configured(Configurator<SFJK200Generator> configurator) {
        configurator.config(this);
    }

    public void writeAddress(int address) {
        this.dataByte[0] = (byte)(address & 0xFF);
        this.bao.write(address);
    }

    public void writeFunction(int function) {
        this.dataByte[1] = (byte)(function & 0xFF);
        this.bao.write(function);
    }

    public void writeStartRegister(int startAddress) throws IOException {
        byte[] bytes = new byte[2];
        bytes[1] = (byte)(startAddress & 0xFF);
        bytes[0] = (byte)(startAddress >>> 8 & 0xFF);
        this.dataByte[2] = bytes[0];
        this.dataByte[3] = bytes[1];
        this.bao.write(bytes);
    }

    public void writeReadRegister(int readAddress) throws IOException {
        byte[] bytes = new byte[2];
        bytes[1] = (byte)(readAddress & 0xFF);
        bytes[0] = (byte)(readAddress >>> 8 & 0xFF);
        this.dataByte[4] = bytes[0];
        this.dataByte[5] = bytes[1];
        this.bao.write(bytes);
    }

    public void writeCrc() throws IOException {
        int crc = AsciiUtil.crcModbusCheck(this.dataByte);
        byte[] bytes = new byte[]{(byte)(crc & 0xFF), (byte)(crc >>> 8 & 0xFF)};
        this.bao.write(bytes);
    }

    @Override
    public void close() throws IOException {
        try {
            this.bao.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

