/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.SFJK200.format;

import cn.allbs.exception.SFJK200Exception;
import cn.allbs.utils.SFJK200.format.SFJK200Factory;
import cn.allbs.utils.SFJK200.format.SFJK200Generator;
import cn.allbs.utils.SFJK200.format.SFJK200Parser;
import cn.allbs.utils.SFJK200.format.der.DataMapDeserializer;
import cn.allbs.utils.SFJK200.format.der.SFJK200Deserializer;
import cn.allbs.utils.SFJK200.format.ser.DataMapSerializer;
import cn.allbs.utils.SFJK200.format.ser.SFJK200Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class SFJK200Mapper {
    private static SFJK200Factory sfjk200Factory;
    private SFJK200Factory factory = sfjk200Factory.copy();

    public <T> T readValue(byte[] msg, int register, Class<T> value) throws IOException, SFJK200Exception {
        if (msg.length == 0) {
            throw new SFJK200Exception("\u5f85\u89e3\u6790\u62a5\u6587\u4e3a\u7a7a!");
        }
        return this._readValueAndClose(this.factory.parser(msg, register), value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T _readValueAndClose(SFJK200Parser sfjk200Parser, Class<T> value) throws IOException, SFJK200Exception {
        SFJK200Deserializer<T> deserializer = this.factory.deserializerFor(value);
        try (SFJK200Parser g = sfjk200Parser;){
            T t = deserializer.deserialize(g);
            return t;
        }
        catch (RuntimeException e) {
            throw new SFJK200Exception("run time error", e.getLocalizedMessage());
        }
    }

    public <T> void writeValueAsStream(T value, Class<T> type, ByteArrayOutputStream outputStream) throws IOException, SFJK200Exception {
        this._writeValueAndClose(this.factory.generator(outputStream), value, type);
    }

    private <T> void _writeValueAndClose(SFJK200Generator generator, T value, Class<T> type) throws IOException, SFJK200Exception {
        SFJK200Serializer<T> serializer = this.factory.serializerFor(type);
        try (SFJK200Generator g = generator;){
            serializer.serialize(g, value);
        }
        catch (RuntimeException e) {
            throw new SFJK200Exception("Runtime error", e);
        }
    }

    public String writeDataAsString(Map<String, Object> data) throws IOException, SFJK200Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.writeValueAsStream(data, Map.class, os);
        return new String(os.toByteArray(), StandardCharsets.UTF_8);
    }

    public byte[] writeDataAsByteArray(Map<String, Object> data) throws IOException, SFJK200Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.writeValueAsStream(data, Map.class, os);
        return os.toByteArray();
    }

    static {
        try {
            sfjk200Factory = new SFJK200Factory();
            sfjk200Factory.deserializerRegister((Type)((Object)Map.class), (Class<? extends SFJK200Deserializer>)DataMapDeserializer.class);
            sfjk200Factory.serializerRegister((Type)((Object)Map.class), (Class<? extends SFJK200Serializer>)DataMapSerializer.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }
}

