/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.SFJK200.format;

import cn.allbs.core.Configurator;
import cn.allbs.core.Configured;
import cn.allbs.exception.SFJK200Exception;
import cn.allbs.utils.AsciiUtil;
import cn.allbs.utils.SFJK200.enums.OrderEnum;
import cn.allbs.utils.SFJK200.enums.PacketElement;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SFJK200Parser
implements Configured<SFJK200Parser>,
Closeable {
    private int count;
    private int verifyFeature;
    protected ByteArrayInputStream dis;
    protected int register;
    protected List<Byte> dataByte;

    public SFJK200Parser(ByteArrayInputStream dis, int register) {
        this.dis = dis;
        this.register = register;
        this.dataByte = new LinkedList<Byte>();
    }

    public int readAddress() throws IOException, SFJK200Exception {
        byte[] address = new byte[PacketElement.ADDRESS.getLen()];
        this.count = this.dis.read(address);
        return AsciiUtil.bytesToShort(address);
    }

    public int readFunction() throws IOException, SFJK200Exception {
        byte[] function = new byte[PacketElement.FUNCTION.getLen()];
        this.count = this.dis.read(function);
        return AsciiUtil.bytesToShort(function);
    }

    public int readDataLen() throws IOException, SFJK200Exception {
        byte[] dataLen = new byte[PacketElement.DATA_LEN.getLen()];
        this.count = this.dis.read(dataLen);
        return AsciiUtil.bytesToShort(dataLen);
    }

    public List<Map<String, Object>> readData(int len) throws SFJK200Exception, IOException {
        byte[] data = new byte[len];
        this.count = this.dis.read(data);
        OrderEnum orderEnum = OrderEnum.orderInfo(this.register);
        if (orderEnum == null) {
            throw new SFJK200Exception("\u8d85\u8fc7\u5bc4\u5b58\u5668\u8303\u56f4!");
        }
        return orderEnum.getAbstractParser().readData(data);
    }

    public byte[] readCheckCrc(int len) throws IOException, SFJK200Exception {
        byte[] crcByte = new byte[PacketElement.CRC_CHECK.getLen()];
        this.count = this.dis.read(crcByte);
        this.dis.reset();
        int needCheckLen = PacketElement.ADDRESS.getLen() + PacketElement.FUNCTION.getLen() + PacketElement.DATA_LEN.getLen() + len;
        byte[] needCheck = new byte[needCheckLen];
        this.dis.read(needCheck, 0, needCheckLen);
        int crcNum = AsciiUtil.bytesToCount(crcByte) & 0xFFFF;
        int crcCheckNum = AsciiUtil.crcModbusCheck(needCheck);
        if (crcCheckNum != -1 && crcNum == crcCheckNum) {
            return crcByte;
        }
        this.dis.reset();
        SFJK200Exception.crc_verification_failed(PacketElement.DATA, needCheck, crcNum);
        return null;
    }

    @Override
    public void configured(Configurator<SFJK200Parser> by) {
        by.config(this);
    }

    @Override
    public void close() throws IOException {
        try {
            this.dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

