/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.SFJK200.format.der;

import cn.allbs.core.Configurator;
import cn.allbs.core.Configured;
import cn.allbs.exception.SFJK200Exception;
import cn.allbs.utils.SFJK200.enums.KeyWordEnum;
import cn.allbs.utils.SFJK200.format.SFJK200Parser;
import cn.allbs.utils.SFJK200.format.der.SFJK200Deserializer;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataMapDeserializer
implements SFJK200Deserializer<Map<String, Object>>,
Configured<DataMapDeserializer> {
    @Override
    public void configured(Configurator<DataMapDeserializer> by) {
        by.config(this);
    }

    @Override
    public Map<String, Object> deserialize(SFJK200Parser sfjk200Parser) throws IOException, SFJK200Exception {
        LinkedHashMap<String, Object> resMap = new LinkedHashMap<String, Object>(17);
        try {
            int address = sfjk200Parser.readAddress();
            resMap.put(KeyWordEnum.ADDRESS.getKey(), address);
            int function = sfjk200Parser.readFunction();
            resMap.put(KeyWordEnum.FUNCTION.getKey(), function);
            int len = sfjk200Parser.readDataLen();
            List<Map<String, Object>> resList = sfjk200Parser.readData(len);
            sfjk200Parser.readCheckCrc(len);
            resMap.put(KeyWordEnum.DATA.getKey(), resList);
        }
        catch (SFJK200Exception | IOException e) {
            throw new SFJK200Exception(e.getLocalizedMessage());
        }
        return resMap;
    }
}

