/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.utils.CommonUtil;
import java.time.LocalDateTime;
import javax.validation.constraints.NotNull;

public final class UuidFormByTimeUtil {
    private static final String[] scale = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int currentYear = 2021;

    public static String uuid(String headPrefix, @NotNull String middlePrefix) {
        return UuidFormByTimeUtil.uuid(2021, headPrefix, middlePrefix);
    }

    public static String uuid(int startYear, String headPrefix, String middlePrefix) {
        LocalDateTime now = LocalDateTime.now();
        startYear = Math.max(2021, startYear);
        int year = Math.max(now.getYear() - startYear, 0);
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        int hour = now.getHour();
        int minute = now.getMinute();
        int second = now.getSecond();
        return CommonUtil.concat(false, headPrefix, middlePrefix, scale[year], scale[month], scale[day], scale[hour], scale[minute], scale[second]);
    }

    private UuidFormByTimeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

