/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.model.EarthPoint2D;
import cn.allbs.model.Point2D;

public final class WGS84MercatorToLngLatUtil {
    public static EarthPoint2D mercatorToWgs84(Point2D point2D) {
        double x = point2D.getX() / 2.003750834E7 * 180.0;
        double y = point2D.getY() / 2.003750834E7 * 180.0;
        y = 57.29577951308232 * (2.0 * Math.atan(Math.exp(y * Math.PI / 180.0)) - 1.5707963267948966);
        return new EarthPoint2D(x, y);
    }

    public static Point2D wgs84ToMercator(EarthPoint2D earthPoint2D) {
        double x = earthPoint2D.getLng() * 2.003750834E7 / 180.0;
        double y = Math.log(Math.tan((90.0 + earthPoint2D.getLat()) * Math.PI / 360.0)) / (Math.PI / 180);
        y = y * 2.003750834E7 / 180.0;
        return new Point2D(x, y);
    }

    public static Double[] lonLatToMercator(Double lat, Double lng) {
        double x = lng * 2.0037508342789E7 / 180.0;
        double y = Math.log(Math.tan((90.0 + lat) * Math.PI / 360.0)) / (Math.PI / 180);
        y = y * 2.0037508342789E7 / 180.0;
        return new Double[]{x, y};
    }

    public static Double[] mercatorToLonLat(Double X, Double Y) {
        double x = X / 2.0037508342789E7 * 180.0;
        double y = Y / 2.0037508342789E7 * 180.0;
        y = 57.29577951308232 * (2.0 * Math.atan(Math.exp(y * Math.PI / 180.0)) - 1.5707963267948966);
        return new Double[]{x, y};
    }

    private WGS84MercatorToLngLatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

