/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.gb26875.format;

import cn.allbs.core.Configurator;
import cn.allbs.core.Configured;
import cn.allbs.exception.GB26875Exception;
import cn.allbs.utils.gb26875.enums.ConstEnum;
import cn.allbs.utils.gb26875.enums.ControlUnitEnum;
import cn.allbs.utils.gb26875.format.GB26875Parser;
import cn.allbs.utils.gb26875.format.der.GB26875Deserializer;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataMapDeserializer
implements GB26875Deserializer<Map<String, Object>>,
Configured<DataMapDeserializer> {
    @Override
    public void configured(Configurator<DataMapDeserializer> by) {
        by.config(this);
    }

    @Override
    public Map<String, Object> deserialize(GB26875Parser gb26875Parser) throws IOException, GB26875Exception {
        LinkedHashMap<String, Object> resMap = new LinkedHashMap<String, Object>(17);
        try {
            gb26875Parser.readHeader();
            resMap.put(ConstEnum.FLOW.getConstDefined(), gb26875Parser.readSerialNum());
            resMap.put(ConstEnum.MAIN_VERSION.getConstDefined(), gb26875Parser.readMainVersion());
            resMap.put(ConstEnum.MINOR_VERSION.getConstDefined(), gb26875Parser.readUserVersion());
            resMap.put(ConstEnum.TIME.getConstDefined(), gb26875Parser.readTime());
            resMap.put(ConstEnum.SOURCE_ADDRESS.getConstDefined(), gb26875Parser.readSourceAddress());
            resMap.put(ConstEnum.TARGET_ADDRESS.getConstDefined(), gb26875Parser.readTargetAddress());
            short dataLen = gb26875Parser.readDataLen();
            resMap.put(ConstEnum.CONTROL_ORDER.getConstDefined(), ControlUnitEnum.orderTrans(gb26875Parser.readControlOrder()));
            resMap.put(ConstEnum.DATA.getConstDefined(), gb26875Parser.readData(dataLen));
            gb26875Parser.readCheck();
        }
        catch (IOException e) {
            throw new GB26875Exception("\u62a5\u6587\u5185\u5bb9\u6709\u8bef!");
        }
        return resMap;
    }
}

