/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.gb26875.format;

import cn.allbs.core.Configurator;
import cn.allbs.core.Configured;
import cn.allbs.exception.GB26875Exception;
import cn.allbs.utils.AsciiUtil;
import cn.allbs.utils.gb26875.enums.ConstEnum;
import cn.allbs.utils.gb26875.enums.PacketElement;
import cn.allbs.utils.gb26875.enums.TypeEnums;
import cn.allbs.utils.gb26875.format.data.AbstractParser;
import cn.allbs.utils.gb26875.utils.VerifyUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class GB26875Parser
implements Configured<GB26875Parser>,
Closeable {
    public static char[] HEADER = new char[]{'@', '@'};
    public static char[] FOOTER = new char[]{'#', '#'};
    protected DataInputStream dataOutputStream;
    protected byte[] msgBytes;
    private int parserFeature;
    private int count;

    public GB26875Parser(byte[] msgBytes) {
        this.msgBytes = msgBytes;
        ByteArrayInputStream bao = new ByteArrayInputStream(msgBytes);
        this.dataOutputStream = new DataInputStream(bao);
    }

    public void setParserFeature(int parserFeature) {
        this.parserFeature = parserFeature;
    }

    public char[] readHeader() throws GB26875Exception, IOException {
        char[] header = new char[PacketElement.HEADER.getLen()];
        this.count = header.length;
        for (int i = 0; i < this.count; ++i) {
            header[i] = (char)this.dataOutputStream.readByte();
        }
        VerifyUtil.verifyLen(this.count, 2, PacketElement.HEADER);
        VerifyUtil.verifyChar(header, HEADER, PacketElement.HEADER);
        return header;
    }

    public short readSerialNum() throws GB26875Exception, IOException {
        byte[] serialNum = new byte[PacketElement.SERIAL_NUM.getLen()];
        this.count = serialNum.length;
        for (int i = 0; i < this.count; ++i) {
            serialNum[i] = this.dataOutputStream.readByte();
        }
        return AsciiUtil.bytesToShort(serialNum);
    }

    public short readMainVersion() throws IOException {
        return (short)(this.dataOutputStream.readByte() & 0xFF);
    }

    public short readUserVersion() throws IOException {
        return (short)(this.dataOutputStream.readByte() & 0xFF);
    }

    public LocalDateTime readTime() throws IOException {
        short[] times = new short[PacketElement.TIME.getLen()];
        this.count = times.length;
        for (int i = 0; i < this.count; ++i) {
            times[PacketElement.TIME.getLen() - 1 - i] = (short)(this.dataOutputStream.readByte() & 0xFF);
        }
        return LocalDateTime.of(times[0] + 2000, times[1], (int)times[2], (int)times[3], (int)times[4], (int)times[5]);
    }

    public String readSourceAddress() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.count = PacketElement.SOURCE_ADDRESS.getLen();
        for (int i = 0; i < this.count; ++i) {
            sb.append((short)(this.dataOutputStream.readByte() & 0xFF));
            if (i == this.count - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    public String readTargetAddress() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.count = PacketElement.TARGET_ADDRESS.getLen();
        for (int i = 0; i < this.count; ++i) {
            sb.append((short)(this.dataOutputStream.readByte() & 0xFF));
            if (i == this.count - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    public short readDataLen() throws GB26875Exception, IOException {
        byte[] dataLen = new byte[PacketElement.APPLICATION_DATA_LEN.getLen()];
        this.count = dataLen.length;
        for (int i = 0; i < this.count; ++i) {
            dataLen[i] = this.dataOutputStream.readByte();
        }
        return AsciiUtil.bytesToShort(dataLen);
    }

    public short readControlOrder() throws IOException {
        return (short)(this.dataOutputStream.readByte() & 0xFF);
    }

    public Map<String, Object> readData(short len) throws GB26875Exception, IOException {
        LinkedHashMap<String, Object> resMap = new LinkedHashMap<String, Object>();
        ArrayList<Map<String, Object>> resMapList = new ArrayList<Map<String, Object>>();
        byte[] data = new byte[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.dataOutputStream.readByte();
        }
        short type = (short)(data[0] & 0xFF);
        if (!TypeEnums.TYPE_PARSER_MAP.containsKey(type)) {
            throw new GB26875Exception("\u8be5\u62a5\u6587\u5185\u5bb9\u672a\u5b9a\u4e49\u89e3\u6790\u65b9\u5f0f");
        }
        resMap.put(ConstEnum.MSG_DATA_TYPE.getConstDefined(), type);
        resMap.put(ConstEnum.MSG_DATA_TYPE_TRANS.getConstDefined(), TypeEnums.TYPE_PARSER_MAP.get(type).getDesc());
        int num = data[1] & 0xFF;
        resMap.put(ConstEnum.MSG_DATA_NUM.getConstDefined(), (short)num);
        int batch = (len - 2) / num;
        for (int i = 0; i < num; ++i) {
            byte[] currentData = new byte[batch];
            System.arraycopy(data, 2, currentData, 0, batch * (i + 1));
            AbstractParser abstractParser = TypeEnums.parserType(type, currentData);
            abstractParser.create();
            resMapList.add(abstractParser.parseMap());
        }
        resMap.put(ConstEnum.MSG_DATA.getConstDefined(), resMapList);
        return resMap;
    }

    public boolean readCheck() throws IOException, GB26875Exception {
        byte[] needCheckBytes = Arrays.copyOfRange(this.msgBytes, PacketElement.HEADER.getLen(), this.msgBytes.length - PacketElement.VERIFY.getLen());
        byte needCheckB = this.dataOutputStream.readByte();
        byte b = AsciiUtil.sumCheck(needCheckBytes, PacketElement.VERIFY.getLen())[0];
        VerifyUtil.verifyCheck(b != needCheckB);
        return true;
    }

    public char[] readFooter() throws GB26875Exception, IOException {
        char[] footer = new char[PacketElement.FOOTER.getLen()];
        this.count = footer.length;
        for (int i = 0; i < this.count; ++i) {
            footer[i] = (char)this.dataOutputStream.readByte();
        }
        VerifyUtil.verifyLen(this.count, 2, PacketElement.FOOTER);
        VerifyUtil.verifyChar(footer, FOOTER, PacketElement.FOOTER);
        return footer;
    }

    @Override
    public void configured(Configurator<GB26875Parser> configurator) {
        configurator.config(this);
    }

    @Override
    public void close() {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int readInt32(int radix) throws IOException {
        char[] intChars = new char[4];
        if (this.count != 4) {
            return -1;
        }
        return Integer.parseInt(new String(intChars), radix);
    }
}

