/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.gb26875.format.data;

import cn.allbs.utils.gb26875.enums.ConstEnum;
import cn.allbs.utils.gb26875.enums.system.Type1SSEnum;
import cn.allbs.utils.gb26875.enums.system.Type1STEnum;
import cn.allbs.utils.gb26875.format.data.AbstractParser;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;

public class Type1Parser
extends AbstractParser {
    public Type1Parser(byte[] bytes) {
        super(bytes);
    }

    @Override
    protected void readSysType() throws IOException {
        short type = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.SYS_TYPE.getConstDefined(), type);
        this.dataMap.put(ConstEnum.SYS_TYPE_TRANS.getConstDefined(), Optional.of(Type1STEnum.TYPE_1_MAP).map(a -> (String)a.get(type)).orElse("\u672a\u5b9a\u4e49"));
    }

    @Override
    protected void readSysAddress() throws IOException {
        short address = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.SYS_ADDRESS.getConstDefined(), address);
    }

    @Override
    protected void readSysDesc() throws IOException {
        byte[] partDesc = new byte[ConstEnum.SYS_DESC.getConstNum().intValue()];
        for (int i = 0; i < ConstEnum.SYS_DESC.getConstNum(); ++i) {
            partDesc[i] = this.dataOutputStream.readByte();
        }
        List<String> list = Type1SSEnum.binaryTrans(partDesc);
        this.dataMap.put(ConstEnum.SYS_DESC.getConstDefined(), String.join((CharSequence)",", list));
    }

    @Override
    protected void readTime() throws IOException {
        short[] times = new short[ConstEnum.HAPPEN_TIME.getConstNum().intValue()];
        for (int i = 0; i < ConstEnum.HAPPEN_TIME.getConstNum(); ++i) {
            times[5 - i] = (short)(this.dataOutputStream.readByte() & 0xFF);
        }
        LocalDateTime time = LocalDateTime.of(times[0] + 2000, times[1], (int)times[2], (int)times[3], (int)times[4], (int)times[5]);
        this.dataMap.put(ConstEnum.HAPPEN_TIME.getConstDefined(), time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
    }
}

