/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.gb26875.format.data;

import cn.allbs.utils.AsciiUtil;
import cn.allbs.utils.gb26875.enums.ConstEnum;
import cn.allbs.utils.gb26875.enums.system.Type1STEnum;
import cn.allbs.utils.gb26875.enums.system.Type2SSEnum;
import cn.allbs.utils.gb26875.enums.system.Type2STEnum;
import cn.allbs.utils.gb26875.format.data.AbstractParser;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;

public class Type2Parser
extends AbstractParser {
    public Type2Parser(byte[] bytes) {
        super(bytes);
    }

    @Override
    protected void readSysType() throws IOException {
        short type = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.SYS_TYPE.getConstDefined(), Integer.valueOf(type));
        this.dataMap.put(ConstEnum.SYS_TYPE_TRANS.getConstDefined(), Optional.of(Type1STEnum.TYPE_1_MAP).map(a -> (String)a.get(type)).orElse("\u672a\u5b9a\u4e49"));
    }

    @Override
    protected void readSysAddress() throws IOException {
        short address = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.SYS_ADDRESS.getConstDefined(), address);
    }

    @Override
    protected void readPartType() throws IOException {
        short partType = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.PART_TYPE.getConstDefined(), Integer.valueOf(partType));
        this.dataMap.put(ConstEnum.PART_TYPE_TRANS.getConstDefined(), Optional.of(Type2STEnum.TYPE_2_MAP).map(a -> (String)a.get(partType)).orElse("\u672a\u5b9a\u4e49"));
    }

    @Override
    protected void readPartAddress() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ConstEnum.PART_ADDRESS.getConstNum(); ++i) {
            sb.append((short)(this.dataOutputStream.readByte() & 0xFF));
            if (i == ConstEnum.PART_ADDRESS.getConstNum() - 1) continue;
            sb.append(".");
        }
        this.dataMap.put(ConstEnum.PART_ADDRESS.getConstDefined(), sb.toString());
    }

    @Override
    protected void readPartDesc() throws IOException {
        byte[] partDesc = new byte[ConstEnum.PART_DESC.getConstNum().intValue()];
        for (int i = 0; i < ConstEnum.PART_DESC.getConstNum(); ++i) {
            partDesc[i] = this.dataOutputStream.readByte();
        }
        List<String> list = Type2SSEnum.binaryTrans(partDesc);
        this.dataMap.put(ConstEnum.PART_DESC.getConstDefined(), String.join((CharSequence)",", list));
    }

    @Override
    protected void readPartExplain() throws IOException {
        byte[] explain = new byte[ConstEnum.PART_EXPLAIN.getConstNum().intValue()];
        for (int i = 0; i < ConstEnum.PART_EXPLAIN.getConstNum(); ++i) {
            explain[i] = this.dataOutputStream.readByte();
        }
        this.dataMap.put(ConstEnum.PART_EXPLAIN.getConstDefined(), AsciiUtil.gb18030ToUtf8(explain));
    }

    @Override
    protected void readTime() throws IOException {
        short[] times = new short[ConstEnum.HAPPEN_TIME.getConstNum().intValue()];
        for (int i = 0; i < ConstEnum.HAPPEN_TIME.getConstNum(); ++i) {
            times[5 - i] = (short)(this.dataOutputStream.readByte() & 0xFF);
        }
        LocalDateTime time = LocalDateTime.of(times[0] + 2000, times[1], (int)times[2], (int)times[3], (int)times[4], (int)times[5]);
        this.dataMap.put(ConstEnum.HAPPEN_TIME.getConstDefined(), time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
    }
}

