/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.gb26875.format.data;

import cn.allbs.utils.AsciiUtil;
import cn.allbs.utils.gb26875.enums.ConstEnum;
import cn.allbs.utils.gb26875.enums.system.Type1STEnum;
import cn.allbs.utils.gb26875.enums.system.Type2STEnum;
import cn.allbs.utils.gb26875.enums.system.Type3AQEnum;
import cn.allbs.utils.gb26875.format.data.AbstractParser;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;

public class Type3Parser
extends AbstractParser {
    public Type3Parser(byte[] bytes) {
        super(bytes);
    }

    @Override
    protected void readSysType() throws IOException {
        short type = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.SYS_TYPE.getConstDefined(), type);
        this.dataMap.put(ConstEnum.SYS_TYPE_TRANS.getConstDefined(), Optional.of(Type1STEnum.TYPE_1_MAP).map(a -> (String)a.get(type)).orElse("\u672a\u5b9a\u4e49"));
    }

    @Override
    protected void readSysAddress() throws IOException {
        short address = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.SYS_ADDRESS.getConstDefined(), address);
    }

    @Override
    protected void readPartType() throws IOException {
        short partType = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.PART_TYPE.getConstDefined(), partType);
        this.dataMap.put(ConstEnum.PART_TYPE_TRANS.getConstDefined(), Optional.of(Type2STEnum.TYPE_2_MAP).map(a -> (String)a.get(partType)).orElse("\u672a\u5b9a\u4e49"));
    }

    @Override
    protected void readPartAddress() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ConstEnum.PART_ADDRESS.getConstNum(); ++i) {
            sb.append((short)(this.dataOutputStream.readByte() & 0xFF));
            if (i == ConstEnum.PART_ADDRESS.getConstNum() - 1) continue;
            sb.append(".");
        }
        this.dataMap.put(ConstEnum.PART_ADDRESS.getConstDefined(), sb.toString());
    }

    @Override
    protected void readAnalogQuantityType() throws IOException {
        short qualityType = (short)(this.dataOutputStream.readByte() & 0xFF);
        Type3AQEnum aqEnum = Optional.of(Type3AQEnum.AQ_ENUMS).map(a -> (Type3AQEnum)((Object)((Object)a.get(qualityType)))).orElse(Type3AQEnum._0);
        this.dataMap.put(ConstEnum.AQ.getConstDefined(), aqEnum);
    }

    @Override
    protected void readAnalogQuantityValue() throws IOException {
        byte[] qualityNum = new byte[ConstEnum.AQ_NUM.getConstNum().intValue()];
        for (int i = 0; i < ConstEnum.AQ_NUM.getConstNum(); ++i) {
            qualityNum[i] = this.dataOutputStream.readByte();
        }
        this.dataMap.put(ConstEnum.AQ_NUM.getConstDefined(), AsciiUtil.bytesToShort(qualityNum));
    }

    @Override
    protected void readTime() throws IOException {
        short[] times = new short[ConstEnum.HAPPEN_TIME.getConstNum().intValue()];
        for (int i = 0; i < ConstEnum.HAPPEN_TIME.getConstNum(); ++i) {
            times[5 - i] = (short)(this.dataOutputStream.readByte() & 0xFF);
        }
        LocalDateTime time = LocalDateTime.of(times[0] + 2000, times[1], (int)times[2], (int)times[3], (int)times[4], (int)times[5]);
        this.dataMap.put(ConstEnum.HAPPEN_TIME.getConstDefined(), time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
    }
}

