/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.gb26875.format.data;

import cn.allbs.utils.AsciiUtil;
import cn.allbs.utils.gb26875.enums.ConstEnum;
import cn.allbs.utils.gb26875.enums.system.Type1STEnum;
import cn.allbs.utils.gb26875.enums.system.Type2STEnum;
import cn.allbs.utils.gb26875.format.data.AbstractParser;
import java.io.IOException;
import java.util.Optional;

public class Type7Parser
extends AbstractParser {
    public Type7Parser(byte[] bytes) {
        super(bytes);
    }

    @Override
    protected void readSysType() throws IOException {
        short type = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.SYS_TYPE.getConstDefined(), type);
        this.dataMap.put(ConstEnum.SYS_TYPE_TRANS.getConstDefined(), Optional.of(Type1STEnum.TYPE_1_MAP).map(a -> (String)a.get(type)).orElse("\u672a\u5b9a\u4e49"));
    }

    @Override
    protected void readSysAddress() throws IOException {
        short address = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.SYS_ADDRESS.getConstDefined(), address);
    }

    @Override
    protected void readPartType() throws IOException {
        short partType = (short)(this.dataOutputStream.readByte() & 0xFF);
        this.dataMap.put(ConstEnum.PART_TYPE.getConstDefined(), partType);
        this.dataMap.put(ConstEnum.PART_TYPE_TRANS.getConstDefined(), Optional.of(Type2STEnum.TYPE_2_MAP).map(a -> (String)a.get(partType)).orElse("\u672a\u5b9a\u4e49"));
    }

    @Override
    protected void readPartAddress() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ConstEnum.PART_ADDRESS.getConstNum(); ++i) {
            sb.append((short)(this.dataOutputStream.readByte() & 0xFF));
            if (i == ConstEnum.PART_ADDRESS.getConstNum() - 1) continue;
            sb.append(".");
        }
        this.dataMap.put(ConstEnum.PART_ADDRESS.getConstDefined(), sb.toString());
    }

    @Override
    protected void readPartExplain() throws IOException {
        byte[] explain = new byte[ConstEnum.PART_EXPLAIN.getConstNum().intValue()];
        for (int i = 0; i < ConstEnum.PART_EXPLAIN.getConstNum(); ++i) {
            explain[i] = this.dataOutputStream.readByte();
        }
        this.dataMap.put(ConstEnum.PART_EXPLAIN.getConstDefined(), AsciiUtil.gb18030ToUtf8(explain));
    }
}

