package cn.allbs.websocket;

import cn.allbs.websocket.handler.AllbsWebSocketHandler;
import cn.allbs.websocket.handler.AllbsWebSocketShakeInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

/**
 * @author ChenQi
 */
@Configuration
@EnableWebSocket
public class WebSocketConfig implements WebSocketConfigurer {

    @Override
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry
                .addHandler(webSocketHandler(), "ws", "", "websocket")
                .addInterceptors(webSocketShakeInterceptor())
                .setAllowedOrigins("*");
    }

    @Bean
    public AllbsWebSocketHandler webSocketHandler() {
        return new AllbsWebSocketHandler();
    }

    @Bean
    public AllbsWebSocketShakeInterceptor webSocketShakeInterceptor() {
        return new AllbsWebSocketShakeInterceptor();
    }

}
