package cn.allbs.websocket.handler;

import cn.allbs.common.enums.WebSocketResponseEnum;
import cn.allbs.websocket.behavior.SendToAllRequest;
import cn.allbs.websocket.enums.MessageType;
import cn.allbs.websocket.message.MessageFactory;
import cn.allbs.websocket.util.WebSocketUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.socket.WebSocketSession;

/**
 * 客户端发送消息至所有在线用户
 *
 * @author ChenQi
 */
public class ClientToAllClientUserHandler implements MessageHandler<SendToAllRequest>, InitializingBean {

    @Override
    public void execute(WebSocketSession session, SendToAllRequest message) {
        WebSocketUtil.broadcast(WebSocketResponseEnum.SEND_TO_ALL, message);
    }

    @Override
    public void afterPropertiesSet() {
        MessageFactory.register(MessageType.SEND_TO_ALL_REQUEST.name(), this);
    }
}
