package cn.allbs.websocket.handler;

import cn.allbs.common.enums.WebSocketResponseEnum;
import cn.allbs.websocket.behavior.SendToUserCountRequest;
import cn.allbs.websocket.message.MessageFactory;
import cn.allbs.websocket.util.WebSocketSessionManager;
import cn.allbs.websocket.util.WebSocketUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.socket.WebSocketSession;

import static cn.allbs.websocket.enums.MessageType.TOTAL_USER_COUNT;

/**
 * 发送指令统计在线用户数量
 *
 * @author ChenQi
 */
public class OnlineUserCountHandler implements MessageHandler<SendToUserCountRequest>, InitializingBean {

    @Override
    public void execute(WebSocketSession session, SendToUserCountRequest message) {
        // 通知客户端当前在线人数
        SendToUserCountRequest count = SendToUserCountRequest.builder().count(WebSocketSessionManager.getOnlineCount()).build();
        WebSocketUtil.send(session, WebSocketResponseEnum.ONLINE_USER_COUNT, count);
    }

    @Override
    public void afterPropertiesSet() {
        MessageFactory.register(TOTAL_USER_COUNT.name(), this);
    }
}
