package cn.allbs.websocket.handler;

import cn.allbs.common.enums.WebSocketResponseEnum;
import cn.allbs.websocket.behavior.SendResponse;
import cn.allbs.websocket.behavior.SendToOneRequest;
import cn.allbs.websocket.enums.MessageType;
import cn.allbs.websocket.message.MessageFactory;
import cn.allbs.websocket.util.WebSocketUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.socket.WebSocketSession;

/**
 * 客户端发送消息给指定用户
 *
 * @author ChenQi
 */
public class PushToOneUserHandler implements MessageHandler<SendToOneRequest>, InitializingBean {

    @Override
    public void execute(WebSocketSession session, SendToOneRequest message) {
        if (!StrUtil.isAllNotEmpty(message.getToUserName(), message.getContent())) {
            SendResponse sendResponse = SendResponse.builder().content("指定用户名称及发送内容不能为空").build();
            WebSocketUtil.send(session, WebSocketResponseEnum.RESPONSE_FAILURE, sendResponse);
            return;
        }
        if (WebSocketUtil.send(message.getToUserName(), WebSocketResponseEnum.RESPONSE_SUCCESS, SendResponse.builder().content(message.getContent()).build())) {
            // 消息发送成功
            SendResponse sendResponse = SendResponse.builder().content("消息发送成功").build();
            WebSocketUtil.send(session, WebSocketResponseEnum.SEND_TO_ONE, sendResponse);
            return;
        }
        // 消息发送成功
        SendResponse sendResponse = SendResponse.builder().content("消息发送失败,指定用户不在线！").build();
        WebSocketUtil.send(session, WebSocketResponseEnum.RESPONSE_FAILURE, sendResponse);
    }

    @Override
    public void afterPropertiesSet() {
        MessageFactory.register(MessageType.SEND_TO_ONE_REQUEST.name(), this);
    }
}
