package cn.allbs.websocket.message;

import cn.allbs.websocket.exception.MessageHandlerException;
import cn.allbs.websocket.handler.MessageHandler;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 消息处理工厂
 *
 * @author ChenQi
 */
public class MessageFactory<T extends Message> {
    private static final Map<String, MessageHandler> STRATEGY_MAP = Maps.newHashMap();

    public static MessageHandler getInvokeStrategy(String str) {
        if (!STRATEGY_MAP.containsKey(str)) {
            throw new MessageHandlerException();
        }
        return STRATEGY_MAP.get(str);
    }

    public static void register(String str, MessageHandler handler) {
        if (StrUtil.isEmpty(str) || null == handler) {
            return;
        }
        STRATEGY_MAP.put(str, handler);
    }
}
