package cn.antcore.resources;

import cn.antcore.resources.convert.impl.*;
import cn.antcore.resources.extend.*;
import cn.antcore.resources.utils.ResourcesUtils;
import cn.antcore.resources.utils.StringUtils;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;

/**
 * 自动识别资源格式并读取
 * Created by Hong on 2017/12/27.
 */
public class AutoResources implements Resources {

    private Resources resources;

    public AutoResources(String path) throws IOException {
        //去除前缀后的资源名
        String propertiesName = ResourcesUtils.getPropertiesName(path);

        if (path.startsWith(PrefixConstants.DB)) {
            //来源 Db
            DbResources resources = new DbResources();
            if (StringUtils.isEmpty(propertiesName)) {
                resources.load();
            } else {
                resources.load(ResourcesUtils.getPropertiesName(path));
            }
            this.resources = resources;
            return;
        } else if (path.startsWith(PrefixConstants.GIT)) {
            //来源 Git
            GitResources resources = new GitResources();
            if (StringUtils.isEmpty(propertiesName)) {
                resources.load();
            } else {
                resources.load(ResourcesUtils.getPropertiesName(path));
            }
            this.resources = resources;
            return;
        }

        if (path.endsWith(SuffixConstants.YAML)) {
            //Yaml资源
            YamlResources resources = new YamlResources();
            if (ResourcesUtils.isClassFile(path)) {
                resources.loadByClassPath(propertiesName);
            } else {
                resources.loadByFilePath(propertiesName);
            }
            this.resources = resources;
        } else if (path.endsWith(SuffixConstants.PROPERTIES)) {
            //Properties资源
            PropertiesResources resources = new PropertiesResources();
            if (ResourcesUtils.isClassFile(path)) {
                resources.loadByClassPath(propertiesName);
            } else {
                resources.loadByFilePath(propertiesName);
            }
            this.resources = resources;
        } else if (path.endsWith(SuffixConstants.XML)) {
            //Xml资源
            XmlResources resources = new XmlResources();
            if (ResourcesUtils.isClassFile(path)) {
                resources.loadByClassPath(propertiesName);
            } else {
                resources.loadByFilePath(propertiesName);
            }
            this.resources = resources;
        }
    }

    @Override
    public Map<Object, Object> getResources() {
        if (resources != null) {
            return resources.getResources();
        }
        return Collections.emptyMap();
    }

    @Override
    public void writeLocalProperties() {
        resources.writeLocalProperties();
    }

    @Override
    public String getValue(String key) {
        return resources == null ? null : new StringConvert().convert(resources.getResources().get(key));
    }

    @Override
    public Boolean getBooleanValue(String key) {
        return resources == null ? null : new BooleanConvert().convert(resources.getResources().get(key));
    }

    @Override
    public Integer getIntegerValue(String key) {
        return resources == null ? null : new IntegerConvert().convert(resources.getResources().get(key));
    }

    @Override
    public Float getFloatValue(String key) {
        return resources == null ? null : new FloatConvert().convert(resources.getResources().get(key));
    }

    @Override
    public Double getDoubleValue(String key) {
        return resources == null ? null : new DoubleConvert().convert(resources.getResources().get(key));
    }

    @Override
    public Character getCharValue(String key) {
        return resources == null ? null : new CharConvert().convert(resources.getResources().get(key));
    }

    @Override
    public Map<Object, Object> getConfig() {
        return resources.getResources();
    }

    @Override
    public void clear() {
        this.resources.clear();
    }
}
