package cn.antcore.resources.config;

import cn.antcore.resources.AutoResources;
import cn.antcore.resources.Resources;

import java.io.IOException;

/**
 * Created by Hong on 2018/1/3.
 */
public abstract class AbstractConfig {

    private final static String[] resourcesNames = {"yaml", "properties", "xml"};

    /**
     * 获取资源文件
     * @param name classpath 文件名
     * @return Resources
     * @throws IOException IOException
     */
    protected Resources getResources(String name) throws IOException {
        return new AutoResources("classpath:" + getResourcesName(name));
    }

    /**
     * 获取存在的资源名
     *
     * @param resourcesName 资源名（不含后缀）
     * @return 资源名
     */
    private String getResourcesName(String resourcesName) {
        for (String name : resourcesNames) {
            name = resourcesName + "." + name;
            if (getClass().getResourceAsStream("/" + name) != null) {
                return name;
            }
        }
        throw new IllegalArgumentException("Resource is not found.");
    }

}
