package cn.antcore.resources.config;

import cn.antcore.resources.AutoResources;
import cn.antcore.resources.Resources;
import cn.antcore.resources.convert.impl.*;
import cn.antcore.resources.utils.StringUtils;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

/**
 * Created by Hong on 2017/12/27.
 */
public class GlobalConfig implements Config, RefreshConfig {

    private final static String[] DEFAULT_RESOURCES = {"classpath:application.yaml", "classpath:application.properties", "classpath:application.xml"};
    private static Map<Object, Object> KVS = new Hashtable<>();
    private String[] tempPath;

    public GlobalConfig() {
        this.tempPath = DEFAULT_RESOURCES;
        this.readResources(DEFAULT_RESOURCES);
    }

    public GlobalConfig(String[] var1) {
        this.tempPath = var1;
        this.readResources(var1);
    }

    private void readResources(String[] var1) {
        for (String name : var1) {
            try {
                if(StringUtils.isEmpty(name)) {
                    continue;
                }
                Resources resources = new AutoResources(name.trim());
                KVS.putAll(resources.getResources());
            } catch (IOException e) {
            }
        }
    }

    @Override
    public String getValue(String key) {
        return new StringConvert().convert(KVS.get(key));
    }

    @Override
    public Boolean getBooleanValue(String key) {
        return new BooleanConvert().convert(KVS.get(key));
    }

    @Override
    public Integer getIntegerValue(String key) {
        return new IntegerConvert().convert(KVS.get(key));
    }

    @Override
    public Float getFloatValue(String key) {
        return new FloatConvert().convert(KVS.get(key));
    }

    @Override
    public Double getDoubleValue(String key) {
        return new DoubleConvert().convert(KVS.get(key));
    }

    @Override
    public Character getCharValue(String key) {
        return new CharConvert().convert(KVS.get(key));
    }

    @Override
    public Map<Object, Object> getConfig() {
        return KVS;
    }

    @Override
    public void clear() {
        KVS.clear();
    }

    @Override
    public void refresh() {
        readResources(this.tempPath);
    }
}

