package cn.antcore.resources.config;

import cn.antcore.resources.Constants;
import cn.antcore.resources.Resources;
import cn.antcore.resources.convert.impl.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created By Hong on 2018/7/30
 **/
public final class SelfConfig extends AbstractConfig implements Config {

    private static Logger LOG = LoggerFactory.getLogger(SelfConfig.class);

    private static Map<Object, Object> KVS = new HashMap<>();
    private static SelfConfig CONFIG = new SelfConfig();

    public static SelfConfig get() {
        return CONFIG;
    }

    private SelfConfig() {
        try {
            Resources resources = super.getResources(Constants.INIT_CONFIG);
            KVS.putAll(resources.getResources());
        } catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Init Config Fail.");
            }
        }
    }

    public void putAll(Map<Object, Object> config) {
        KVS = config;
    }

    public void put(Object key, Object value) {
        KVS.put(key, value);
    }

    @Override
    public String getValue(String key) {
        return new StringConvert().convert(KVS.get(key));
    }

    @Override
    public Boolean getBooleanValue(String key) {
        return new BooleanConvert().convert(KVS.get(key));
    }

    @Override
    public Integer getIntegerValue(String key) {
        return new IntegerConvert().convert(KVS.get(key));
    }

    @Override
    public Float getFloatValue(String key) {
        return new FloatConvert().convert(KVS.get(key));
    }

    @Override
    public Double getDoubleValue(String key) {
        return new DoubleConvert().convert(KVS.get(key));
    }

    @Override
    public Character getCharValue(String key) {
        return new CharConvert().convert(KVS.get(key));
    }

    @Override
    public Map<Object, Object> getConfig() {
        return KVS;
    }

    @Override
    public void clear() {
        KVS.clear();
    }
}
