package cn.antcore.resources.core;

import cn.antcore.resources.KeyConstants;
import cn.antcore.resources.config.SelfConfig;
import cn.antcore.resources.db.DbUtils;
import cn.antcore.resources.db.select.Select;
import cn.antcore.resources.utils.Args;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.*;

/**
 * Created By Hong on 2018/7/30
 **/
public class DbProperties extends Hashtable<Object, Object> {

    private static final SelfConfig CONFIG = SelfConfig.get();

    /**
     * 创建没有默认资源的空资源
     */
    public DbProperties() {
        super();
    }

    /***
     * 创建有默认资源的非空资源
     * @param defaults  默认
     */
    public DbProperties(Properties defaults) {
        super(defaults);
    }

    public synchronized Object setProperty(String key, String value) {
        return super.put(key, value);
    }

    public synchronized void load() {
        this.load(CONFIG.getValue(KeyConstants.DB_TABLE_NAME));
    }

    public synchronized void load(String tableName) {
        String sql = new Select()
                .table(tableName)
                .columnAll()
                .toString();
        List<Map<String, Object>> list = DbUtils.select(sql);
        for (Map<String, Object> item : list) {
            this.put(item.get(KeyConstants.DB_CONFIG_KEY), item.get(KeyConstants.DB_CONFIG_VALUE));
        }
    }

}
